#ifdef ENABLE_LYNX

#include <errno.h>
#include "common.h"
#include "lynx.h"

/* init_lynx()
 * sets up the SCRIPT_NAME and Config.use_lynx variables for use with lynx
 */

void
init_lynx(char *prog_name) {
	DIR *dir_ptr = NULL;
	struct dirent *dir_entry = NULL;
	int prog_len = 0;
	char *end = NULL;
	char *dir_name = NULL;
	char *full_path = NULL;
	char *env_path = getenv("PATH");
	char *cur = env_path;

	if(prog_name == NULL) {
		prog_name = PACKAGE_NAME;
	}
	
	prog_len = strlen(prog_name);

	Config.use_lynx = 1;

	if(strchr(prog_name, '/') != NULL) {
		full_path = strdup(prog_name);
	} else {
		/* find the path to executable */
		while((end = strchr(cur, ':')) != NULL) {
			dir_name = strndup(cur, end - cur);

			dir_ptr = opendir(dir_name);

			if(dir_ptr != NULL) {
				while((dir_entry = readdir(dir_ptr)) != NULL) {
					if(strcmp(prog_name, dir_entry->d_name) == 0) {
						full_path = str_app_s(full_path, dir_name);
						full_path = str_app_s(full_path, "/");
						full_path = str_app_s(full_path, dir_entry->d_name);
						break;
					}
				}
			}

			free(dir_name);

			if(full_path != NULL) {
				break;
			}

			cur = end + 1;
		}
	}

	if(full_path != NULL) {
		add_query_option(SCRIPT_NAME, full_path);
		free(full_path);
	}

}

void
launch_lynx() {
	char *arg_string = NULL;
	int size = 0;
	char *program = get_query_value(PROGRAM);
	char *script_name = get_query_value(SCRIPT_NAME);
	char *section = get_query_value(SECTION);

	if(script_name == NULL) {
		usage(1);
		/* not reached */
	}

	if(program == NULL) {
		size = strlen(LYNX_SHORT_HREF) + strlen(script_name) + 2;
		arg_string = calloc(1, size);
		sprintf(arg_string, LYNX_SHORT_HREF, script_name);
	} else {
	
		size = strlen(LYNX_HREF);
		size += strlen(program) + strlen(script_name) + 2;

		if(section != NULL) {
			size += strlen(section) + 1;
			arg_string = calloc(1, size);
			sprintf(arg_string, LYNX_HREF, script_name, program, section);
		} else {
			arg_string = calloc(1, size);
			sprintf(arg_string, LYNX_HREF, script_name, program, "");
		}
	}

	execlp("lynx", "lynx", arg_string, 0);
	/* not reached */

}
#endif /* ENABLE_LYNX */
