/* $Id: header_footer.c,v 1.15 2003/04/24 00:33:34 jtalkington Exp $ */

#include "common.h"
#include "header_footer.h"


/* output_header()
 * prints out the header for the page, including the program name and
 * section if provided.
 */
void
output_header(char *program, char *section) {
	
	if(Config.mode != COMMAND_MODE) {
		printf("Content-type: text/html; charset=UTF-8\n\n");
	}
	
	printf("%s\n", DOCTYPE_HEADER);

	printf("%s\n<head>\n", HTML_START);
	printf("<style type=\"text/css\">\n");

	output_style_sheet();

	printf("</style>\n");
	printf("<title>Man Page Lookup");
	
	if(program != NULL) {
		printf(" - %s", program);
	}

	if(section != NULL) {
		printf(" (%s)", section);
	}

	printf("\n");
	
	printf("</title>\n");
	printf("</head>\n<body>\n");
	fflush(stdout);
}

/* output_footer()
 * prints out the search form and HTML footer for every page.
 */

void
output_footer() {
	char *script_name = get_query_value(SCRIPT_NAME);
		
	if(script_name != NULL) {
		output_search_form();
		printf("<a href=\"%s\">%s Home...</a>\n", script_name, PACKAGE_NAME);
	}
	
	printf("</body>\n</html>\n");
	fflush(stdout);
}

/* add_to_style_sheet()
 * adds elements to the style sheet that is sent with every page
 */
void
add_to_style_sheet(char *line) {
	char *name_end = NULL;
	char *name = line;

	if(line == NULL) {
		return;
	}

	name_end = line;

	while(*name_end != ' ' && *name_end != '\t' && *name_end != '\0' && *name_end != '\n' && *name_end != '\r') {
		name_end++;
	}

	name = strndup(name, name_end - name);

	add_element(&Config.style_sheet, name, line);

	free(name);
}

/* add_element()
 * internal for add_to_style_sheet()
 */
void
add_element(struct Style_Sheet_Element **element, char *name, char *line) {

	if(name == NULL || line == NULL) {
		return;
	}

	if((*element) == NULL) {
		(*element) = calloc(1, sizeof(struct Style_Sheet_Element));
		(*element)->name = strdup(name);
		(*element)->line = strdup(line);
		return;
	}

	if(strcmp(name, (*element)->name) == 0) {
		/* replace an element if it is duplicated */
		free((*element)->line);
		(*element)->line = strdup(line);
		return;
	} else {
		add_element(&(*element)->next, name, line);
	}
}

/* init_default_style_sheet()
 * adds default elements to the style sheet if none are specified
 */
void
init_default_style_sheet() {
	char *line = default_style_sheet_elements[0];
	int i = 0;

	for(; line != NULL; i++) {
		line = default_style_sheet_elements[i];
		add_to_style_sheet(line);
	}
}

/* output_style_sheet_config()
 * outputs the style sheet in a manner that is suitable for the config
 * file.
 */
void
output_style_sheet_config() {
	struct Style_Sheet_Element *cur = Config.style_sheet;

	for(cur = Config.style_sheet; cur != NULL; cur = cur->next) {
		printf("STYLE %s\n", cur->line);
	}
}

/* output_style_sheet()
 * prints out the style sheet for the output_header()
 */
void
output_style_sheet() {
	struct Style_Sheet_Element *cur = Config.style_sheet;

	for(cur = Config.style_sheet; cur != NULL; cur = cur->next) {
		printf("\t%s\n", cur->line);
	}
}

#ifdef M2W_CLEANUP

/* cleanup_style_sheet()
 * wrapper to free() up the Config.style_sheet
 */
void
cleanup_style_sheet() {
	cleanup_style_sheet_element(&Config.style_sheet);
}

/* cleanup_style_sheet_element()
 * recursively free()s the Config.style_sheet tree
 */
void
cleanup_style_sheet_element(struct Style_Sheet_Element **element) {
	struct Style_Sheet_Element *next = NULL;

	if((*element) == NULL) {
		return;
	}

	if((*element)->next != NULL) {
		next = (*element)->next;
	}

	free((*element)->name);
	free((*element)->line);
	free((*element));

	if(next != NULL) {
		cleanup_style_sheet_element(&next);
	}
}

#endif /* M2W_CLEANUP */
