/* $Id: common.h,v 1.22 2003/04/24 00:33:34 jtalkington Exp $ */

#ifndef MAN2WEB_COMMON_H
#define MAN2WEB_COMMON_H 1

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#if STDC_HEADERS
#  include <stdlib.h>
#  include <string.h>
#elif HAVE_STRINGS_H
#  include <strings.h>
#endif /*STDC_HEADERS*/

#if HAVE_UNISTD_H
#  include <unistd.h>
#endif


#include <stdio.h>
#include <sys/types.h>
/* autoconf suggested code */

#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif


/* used for get_query_value() */
#define PROGRAM "program"
#define SCRIPT_NAME "script_name"
#define SECTION "section"
#define RAW "raw"
#define MODE "mode"
#define SECTION_INDEX "section-index"
#define APROPOS "apropos"
#define USER_AGENT "user-agent"

/* user agent types */
#define UA_MSIE (1<<0)

/* the section entry struct */
struct section_entry {
        char *pseudo_section;
	char *real_section;
        char *desc;
        struct section_entry *left;
        struct section_entry *right;
};


/* the config struct */
struct Config_struct {
	char *man_command;
	char *manpath_sw;
	char *manpath;
	char *section_sw;
	char *apropos;
	struct section_entry *sections;
	struct Style_Sheet_Element *style_sheet;
	int disabled;
	int mode;
#if ENABLE_LYNX
	int use_lynx;
#endif
};

/* Config.disabled values */
#define CONFIG_INVALID (1<<0)
#define D_INDEXES (1<<1)
#define D_APROPOS (1<<2)

/* Config.mode values */
enum {
	COMMAND_MODE = 1,
	CGI_MODE = 2,
};

extern struct Config_struct Config;


/* prototypes */

/* config/query functions */
extern int init_config(void);
extern void init_query_tree(int argc, char *argv[]);
extern void init_default_style_sheet(void);
extern void init_default_sections(void);
extern void add_to_style_sheet(char *line);
extern void parse_options(int argc, char *argv[]);
extern char *get_query_value(char *name);
extern void output_config(void);
extern void output_style_sheet_config(void);
extern int parse_section_line(char *line);
extern void output_section_config(void);
extern void add_query_option(char *name, char *value);

/* cover/search page functions */
extern void output_search_form(void);
extern void output_cover_page(void);
extern void output_header(char *program, char *section);
extern void output_footer(void);

/* the types of output */
extern void output_man_page(char *program, char *section);
extern void output_apropos(char *keyword);
extern void output_section_index(char *section);

/* section functions */
extern char *get_real_section(char *pseudo);
extern void usage(int e_value);

/* misc functions */
extern int is_invalid_url_char(char ch);

/* lynx functions */
#ifdef ENABLE_LYNX
void init_lynx(char *prog_name);
void launch_lynx(void);
#endif


/* this stops valgrind from complaining about memory leaks from stuff
 * we are going to free when we exit anyway...
 */
#ifdef M2W_CLEANUP
extern void cleanup_query_tree(void);
extern void cleanup_style_sheet(void);
extern void cleanup_config(void);
extern void cleanup_sections(void);
#endif /* M2W_CLEANUP */

/* string functions */
extern char *str_app_s(char *line, char *append);
extern char *str_app_c(char *line, const char append);
extern char *skip_white(char *line);

#ifndef HAVE_DECL_STRNDUP
extern char *strndup(const char *s, size_t n);
#endif

#endif /* MAN2WEB_COMMON_H */
