/* $Id: cmd_opts.c,v 1.11 2003/04/26 06:13:04 jtalkington Exp $ */

#include "common.h"
#include "cmd_opts.h"

/* parse_options
 * parses the command line
 */
void
parse_options(int argc, char *argv[]) {
	int c = 0;
	int do_index = 0;
	extern char *optarg;
	extern int optind;

#if ENABLE_LYNX
	char *sh_opts = "s:akiprvhl";
#else
	char *sh_opts = "s:akiprvh";
#endif

	static struct option long_options[] = {
		{ "apropos", 0, 0, 'a'},
		{ "keyword", 0, 0, 'a'},
		{ "print-config", 0, 0, 'p'},
		{ "section", 1, 0, 's'},
		{ "raw", 0, 0, 'r'},
		{ "version", 0, 0, 'v'},
		{ "help", 0, 0, 'h'},
#if ENABLE_LYNX
		{ "lynx", 0, 0, 'l' },
#endif
		{ "index", 1, 0, 'i'},
		{ 0, 0, 0, 0}
	};

	while((c = getopt_long(argc, argv, sh_opts, long_options, (int *)0)) != -1) {
		switch(c) {
			case 'a':
			case 'k':
				if(get_query_value(SECTION) != NULL) {
					usage(1);
					/* not reached */
				} else {
					add_query_option(SECTION, "apropos");
				}
				break;
			case 'i':
				if(optarg != NULL) {
					add_query_option(SECTION, optarg);
				}

				add_query_option(PROGRAM, SECTION_INDEX);

				do_index = 1;
				break;
			case 'p':
				output_config();
#ifdef M2W_CLEANUP
				cleanup_config();
#endif
				exit(0);
				/* not reached */
				break;
			case 's':
				if(get_query_value(SECTION) != NULL) {
					usage(1);
					/* not reached */
				} else {
					add_query_option(SECTION, optarg);
				}
				break;
			case 'r':
				add_query_option(RAW, "1");
				break;
#ifdef ENABLE_LYNX
			case 'l':
				init_lynx(argv[0]);
				break;
#endif
			case 'v':
				printf("%s Version %s\n", PACKAGE_NAME, PACKAGE_VERSION);
				exit(0);
				/* not reached */
			case 'h':
				usage(0);
				/* not reached */
			default:
				usage(1);
				/* not reached */
				break;
		}
	}
	
	if(optind < argc) {
		if(do_index == 0) {
			add_query_option(PROGRAM, argv[optind]);
		} else if(get_query_value(SECTION) == NULL) {
			add_query_option(SECTION, argv[optind]);
		} else {
			usage(1);
			/* not reached */
		}
	}

#ifdef ENABLE_LYNX
	/* exec lynx if -l was given */
	if(Config.use_lynx != 0) {
		launch_lynx();
		/* not reached */
	}
#endif
		
}

/* usage()
 * prints out usage information, and exits with the int passed
 */
void
usage(int e_value) {
	fprintf(stderr, "%s version %s\n\n"
			"Usage: %s [options] [name]\n"
			"\n"
			"Options:\n"
			"       -k | -a"
			"       --apropos\n"
			"       --keyword      keyword (apropos) search\n"
			"       -s section\n"
		  	"       --section=section\n"
			"                      specify the section\n"
			"       -i section\n"
			"       --index=section\n" 
			"                      print an index of a section\n"
#ifdef ENABLE_LYNX
			"       -l, --lynx     display the output in lynx\n"
#endif
			"       -p, --print-config\n"
			"                      print the current configuration\n"
			"       -r, --raw      print raw man output (do not convert to HTML)\n"
			"       -h, --help     display this help\n"
			"       -v, --version  display the version and exit\n"
			"\n",

	       PACKAGE_NAME, PACKAGE_VERSION, PACKAGE);

#ifdef M2W_CLEANUP
	cleanup_query_tree();
	cleanup_config();
#endif /* M2W_CLEANUP */
	exit(e_value);

}
