/*
	$Workfile:$
	$Header: /usr/local/cvsroot/mal/install/MALUnInstall/MALUnInstall.cpp,v 1.1 1999/04/29 20:54:36 dave Exp $


	@doc
	@module _Uninstall.cpp - Uninstaller template |

	This file will contain the implemenation of the two functions that will be called
	before and after the uninstaller does its job.

	This code is Unicode compliant - if you want to compile with UNICODE, please
	define _UNICODE in the C++ preprocessor.  If you do nothing, this will compile
	to ANSI. (Delete this comment if you code to ANSI only).

	In case you are wondering about the weird tags in the code - its for a documentation
	tool called Autoduck.

	I have tested the DLL to make sure that those two functions get called.  I am including
	an InstallShield script function that shows how to patch installshield so that the
	uninstaller loads your dll.  If you install ODBC or things like it, make sure you call
	the function in the script after installing ODBC.


	Revision History:
		1999 April 19 - Initial Revision   Friedrich Brunzema  (brunzefb@aracnet.net)

	$Log: MALUnInstall.cpp,v $
	Revision 1.1  1999/04/29 20:54:36  dave
	Added support for MAL to put up a warning panel at uninstall time
	
	Revision 1.1  1999/04/27 04:19:55  dave
	Added dll to support prompting before uninstalling MAL

*/


#include <Windows.h>
#include <Winbase.h>
#include <Winnt.h>
#include <tchar.h>				// for Unicode compliant code
#include <winreg.h>
#include <stdio.h>
#include "MALUnInstall.h"			// Prototypes
#include "resource.h"

const TCHAR * HKEY_MAL_CURRENT_USER_ROOT =
    TEXT("Software\\Mobile Application Link");

const TCHAR *IMAGE_KEY = TEXT("Progress Bitmap Filename");
const TCHAR *MESSAGE_KEY = TEXT("Uninstall Message");

static HINSTANCE hInst;
/*
#include "util.h"				// uncomment if you want to use my utilities
								// if you don't use the util functions,
								// you can delete the util.cpp from the build.
*/


/*
	Don't be tempted to put static variables here - it won't work.  Reason is:
	IS loads the DLL, calls UninstInitialize then unloads this DLL.  The unloading
	causes the static data to disappear.
*/


/*
	@func DLLMain

	This function is the main entry point into the DLL.

	@parm	HINSTANCE	| hInstance		| The instance
	@parm	DWORD		| dwReason		| Why called
	@parm	short		| digits		| The number of decimal places
										  to use.
	@parm	LPVOID		| 				| reserved

*/
extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
	}
    hInst = hInstance;
	return TRUE;    // ok
}


static LPTSTR GetStringConstant(LPCTSTR key)
{
    HKEY rootKey = NULL;
    HRESULT hr;
    void * result = NULL;
    BOOL gotSomething = FALSE;

    hr = RegOpenKeyEx(HKEY_CURRENT_USER, HKEY_MAL_CURRENT_USER_ROOT,
        0, KEY_EXECUTE, &rootKey);

    if (ERROR_SUCCESS == hr) {
    
        DWORD bufsize = 0;
        DWORD valueType = 0;

        hr = RegQueryValueEx(rootKey, key, 0,
            &valueType, NULL, &bufsize);
        if (ERROR_SUCCESS == hr) {
            result = (LPTSTR)malloc(bufsize * sizeof(TCHAR));
            hr = RegQueryValueEx(rootKey, key, 0,
                &valueType, (unsigned char *)result, &bufsize);
        }
        RegCloseKey(rootKey);
    }
    return (LPTSTR)result;
}

static void initDialog(HWND hwnd, LPCTSTR message) {
    LPTSTR prototype = GetStringConstant(IMAGE_KEY);
    LONG ret = 0;

    if (prototype) {
        TCHAR *filename = (TCHAR *)malloc(strlen(prototype) + 10);
        HANDLE image;
        sprintf(filename, prototype, 0);
        image = LoadImage(NULL,
                        filename,
                        IMAGE_BITMAP,
                        0,
                        0,
                        LR_LOADFROMFILE |
                        LR_LOADMAP3DCOLORS |
                        LR_LOADTRANSPARENT);
        SendMessage(GetDlgItem(hwnd, IDC_IMAGE), STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)image);
        free(filename);
        free(prototype);
    }
    SendMessage(GetDlgItem(hwnd, IDC_MESSAGE), WM_SETTEXT, 0, (LPARAM)message);
}

static BOOL CALLBACK WarningProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch(message)
    {
    case WM_INITDIALOG:
        initDialog(hwnd, (LPCTSTR)lParam);
        return TRUE;
    case WM_COMMAND:
        if (wParam == IDCANCEL || wParam == IDOK) {
            EndDialog(hwnd, wParam);
            return TRUE;
        }
        break;
    }

    return FALSE;
}

/*
	@func UninstInitialize

	This function is called by the uninstaller before doing any uninstalling.

	@parm	HWND	| hwndDlg		| The window handle of the parent
	@parm	HANDLE	| hInst			| The instance handle of the Uninst app
	@parm	LONG	|				| reserved.
	@retval LONG  return >=0 to continue uninstalling, <0 if uninstall is to stop
*/
extern "C" LONG WINAPI
UninstInitialize(HWND hwndDlg, HINSTANCE hInstanceParent, LONG)
{
	/*
		This function is called immediately before the uninstall begins.
		Add custom functionality below - for catastropical errors where
		you do not wish uninstallation to proceed, return -1
	*/

    LPTSTR message = GetStringConstant(MESSAGE_KEY);
    if (message) {
        LONG ret = DialogBoxParam(hInst, MAKEINTRESOURCE(IDD_WARNING), hwndDlg, WarningProc, (LPARAM)message);
        free(message);
        return ret == IDCANCEL ? -1 : 0;
    } else {
        return 0;
    }
}


/*
	@func UninstUnInitialize

	This function is called by the uninstaller after finishing its uninstalling.

	@parm	HWND	| hwndDlg		| The window handle of the parent
	@parm	HANDLE	| hInst			| The instance handle of the Uninst app
	@parm	LONG	|				| reserved.
	@retval LONG  return >=0 to continue uninstalling, <0 if uninstall is to stop

*/
extern "C" LONG WINAPI
UninstUnInitialize(HWND hwndDlg, HINSTANCE hInstanceParent, LONG)
{
/*
		This function is called immediately after the uninstall finsishes, but before
		uninstaller is unloaded.  Here's your chance to do some extra cleanup.
		Add custom functionality below - for catastropical errors where
		you do not wish uninstallation to proceed, return -1
	*/

	// return OK to uninstaller
	return 0;
}







