/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#ifdef __cplusplus
extern "C" {
#endif

#include <windows.h>

const LPTSTR cleanupAppName = TEXT("\\Windows\\MALCleanup.exe");

/*  Those who include this will get it as a declaration of stuff to import.
    We will use it to declare our exports.
*/
#ifdef MALSETUPDLL_EXPORTS
#define MALSETUPDLL_API __declspec(dllexport)
#else
#define MALSETUPDLL_API __declspec(dllimport)
#endif

MALSETUPDLL_API int Install_Init(HWND hwndParent,
                                 BOOL fFirstCall,
                                 BOOL fPreviouslyInstalled,
                                 LPCTSTR pszInstallDir);

MALSETUPDLL_API int Install_Exit(HWND hwndParent,
                                 LPCTSTR pszInstallDir,
                                 WORD cFailedDirs,
                                 WORD cFailedFiles,
                                 WORD cFailedRegKeys,
                                 WORD cFailedRegVals,
                                 WORD cFailedShortcuts);

MALSETUPDLL_API int Uninstall_Init(HWND hwndParent,
                                   LPCTSTR pszInstallDir);

MALSETUPDLL_API int Uninstall_Exit(HWND hwndParent);

MALSETUPDLL_API void Install_DoCleanup(void);

#ifdef __cplusplus
}       // extern "C"
#endif