/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#ifndef __AGPROTECTEDMEM_H__
#define __AGPROTECTEDMEM_H__

#include <AGTypes.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#if !((defined __palmos__) || (defined USE_CUSTOM_PROTECTED_MEMORY))

// These do nothing off the palm platform
#define AGProtectedMemoryInit(void)
#define AGProtectedMemoryFinalize(void)

#define AGProtectedMalloc(len) (const void *)malloc((len))
#define AGProtectedRealloc(ptr, len)  (const void *)realloc((void *)(ptr), (len))
#define AGProtectedWrite(dst, offset, src, len) \
            memmove((((uint8 *)dst)+offset), (src), (len))
#define AGProtectedFree(ptr) free((void *)(ptr))
#define AGProtectedZero(ptr, offset, len) memset((((uint8 *)ptr)+offset), 0, (len))
#define AGProtectedStrDup(ptr) strdup(ptr)

#else

typedef struct AGProtectedHeader {
    uint32 magicCookie;
    uint32 recordId;
} AGProtectedHeader;

ExportFunc int16 AGProtectedMemoryInit(void);
ExportFunc void AGProtectedMemoryFinalize(void);
ExportFunc const void *AGProtectedMalloc(uint32 len);
ExportFunc const void *AGProtectedRealloc(void *ptr, uint32 len);
ExportFunc uint16 AGProtectedWrite(void *dst, uint32 offset, 
                                    void *src, uint32 len);
ExportFunc void AGProtectedFree(void *ptr);
ExportFunc void AGProtectedZero(void *ptr, uint32 offset, uint32 len);
ExportFunc char *AGProtectedStrDup(char *str);

#endif /* !__palmos__ */

#ifdef __cplusplus
}
#endif // __cplusplus

#endif /* __AGPROTECTEDMEM_H__ */

