/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#ifndef __AGLOCATIONCONFIG_H__
#define __AGLOCATIONCONFIG_H__

#include <AGTypes.h>
#include <AGReader.h>
#include <AGWriter.h>
#include <AGArray.h>

#ifdef __cplusplus
    extern "C" {
#endif /* __cplusplus */

typedef enum {
    AG_PROXY_INCOMPLETE = 0,
    AG_PROXY_FAILED,
    AG_PROXY_USER_SUPPLIED,
    AG_PROXY_MSIE,
    AG_PROXY_Netscape,
    AG_PROXY_Opera       // pending(miket): not currently supported
} AGLocationConfigSource;

typedef enum {
    AG_PROXY_NO_ERROR = 0,
    AG_PROXY_NULL_POINTER,
    AG_PROXY_NONE_FOUND
} AGLocationConfigResult;

/*  Note:  This data structure has been published to the world.
    If anything in it changes, it must remain compatible with previous
    versions.
*/
typedef struct AGLocationConfig {

    AGLocationConfigSource source;

    AGBool HTTPUseProxy;
    char * HTTPName;
    int32 HTTPPort;
    AGBool HTTPUseAuthentication;
    char * HTTPUsername;
    char * HTTPPassword;

    AGBool SOCKSUseProxy;
    char * SOCKSName;
    int32 SOCKSPort;

    char * autoConfigProxyURL;

    AGArray * exclusionServers;
    AGBool bypassLocal;

} AGLocationConfig;

ExportFunc AGLocationConfig * AGLocationConfigNew(void);
ExportFunc void AGLocationConfigFree(AGLocationConfig * locationConfig);
ExportFunc void AGLocationConfigInit(AGLocationConfig * locationConfig);
ExportFunc void AGLocationConfigFinalize(AGLocationConfig * locationConfig);

ExportFunc void AGLocationConfigReadData(AGLocationConfig * locationConfig,
                                         AGReader * r);
ExportFunc AGLocationConfig * AGLocationConfigNewAndReadData(AGReader * r);
ExportFunc void AGLocationConfigWriteData(AGLocationConfig * locationConfig,
                                          AGWriter * w);
ExportFunc AGLocationConfigSource AGLocationConfigGetSource(AGLocationConfig *
                                                            locationConfig);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // #ifndef __AGLOCATIONCONFIG_H__