
#include "Setup.h"
#include <ras.h>
#include <RASERROR.H>

#define CONTINUE 0
#define CANCEL 1

#define SYNC_DLL L"\\Windows\\MALCLMGR.dll"
#define BACKUP_SYNC_DLL L"\\Windows\\_MALCLMGR.dll"

BOOL installCanceled;
BOOL uninstallCanceled;

int checkForRunningClient(HWND hwndParent)
{
    // Check if AvantGo is already running...
    HWND mainWindow = FindWindow(L"AvantGo Mobile Link Main Window Class", L"AvantGo Mobile Link Main Window Class");
    if (mainWindow != NULL) {
        if (MessageBox(hwndParent, L"You are already running a version of MobileLink.  Continuing will cause it to be terminated.",
            L"Install Mobile Application Link", MB_OK) == MB_OKCANCEL) {
            PostMessage(mainWindow, WM_CLOSE, 0, 0);
        } else {
            return CANCEL;
        }
    }

    return CONTINUE;
}

extern BOOLEAN checkForConnection()
{
    RASCONN* pRasConn = NULL;
    DWORD result = -1;
    int rasConnSize = sizeof(RASCONN);
    unsigned long numConnections, totalSize = rasConnSize;
    BOOLEAN establishedConnection = FALSE;

    pRasConn = (RASCONN*)malloc(rasConnSize);
    memset(pRasConn, 0, rasConnSize);
    pRasConn->dwSize = rasConnSize;
    result = RasEnumConnections(pRasConn, &totalSize, &numConnections);
    if (result == ERROR_BUFFER_TOO_SMALL) {
        free(pRasConn);
        pRasConn = (RASCONN*)malloc(totalSize);
        result = RasEnumConnections(pRasConn, &totalSize, &numConnections);
    }

    if (result == 0 && numConnections != 0) {
        unsigned long index, entrySize = sizeof(RASENTRY);
        RASCONNSTATUS status;

        for (index = 0; index < numConnections; index++) {
            if (establishedConnection)
                break;

            memset(&status, 0, sizeof(status));

            DWORD connectStatus = RasGetConnectStatus(&pRasConn[index], &status); // This doesn't seem to return 0 on success...

            if (status.dwError == 0 && status.rasconnstate == RASCS_OpenPort)
                establishedConnection = TRUE;
        }
    }

    free(pRasConn);

    return establishedConnection;
}

void agPreUninstall()
{
    // Delete stuff in the AvantGo directory...
    DeleteFile(L"\\windows\\malconfig.dat");

    // Delete registry stuff...
    RegDeleteKey(HKEY_CURRENT_USER, L"Software\\Mobile Application Link\\Servers"); 
    RegDeleteKey(HKEY_LOCAL_MACHINE, L"Windows CE Services\\Synchronization\\Objects\\Mobile Application Link");
}

void agPostUninstall()
{
    // Delete the backup AGCESyncDev dll...
    DeleteFile(BACKUP_SYNC_DLL);

    // Delete the AGCESyncDev dll too...
    if (!DeleteFile(SYNC_DLL) && GetLastError() == ERROR_ACCESS_DENIED) {
        DeleteFile(BACKUP_SYNC_DLL);
        MoveFile(SYNC_DLL, BACKUP_SYNC_DLL);
    }

    // Delete registry stuff again...(shouldn't be necessary)
    RegDeleteKey(HKEY_CURRENT_USER, L"Software\\Mobile Application Link\\Servers"); 
    RegDeleteKey(HKEY_LOCAL_MACHINE, L"Windows CE Services\\Synchronization\\Objects\\Mobile Application Link");
}

void agPreInstall()
{
    // Uninstall old version of AvantGo Client
    agPreUninstall();
    agPostUninstall();
}

void agPostInstall()
{
}

codeINSTALL_INIT Install_Init(HWND hwndParent,
                              BOOL fFirstCall,
                              BOOL fPreviouslyInstalled,
                              LPCTSTR pszInstallDir)
{
    installCanceled = false;

    if (checkForRunningClient(hwndParent) == CANCEL) {
        installCanceled = true;

        return codeINSTALL_INIT_CANCEL;
    }

    agPreInstall();

    return codeINSTALL_INIT_CONTINUE;
}

codeINSTALL_EXIT Install_Exit(HWND hwndParent,
                              LPCTSTR pszInstallDir,
                              WORD cFailedDirs,
                              WORD cFailedFiles,
                              WORD cFailedRegKeys,
                              WORD cFailedRegVals,
                              WORD cFailedShortcuts)
{
    if (!installCanceled)
        agPostInstall();

    return codeINSTALL_EXIT_DONE;
}

codeUNINSTALL_INIT Uninstall_Init(HWND hwndParent,
                                  LPCTSTR pszInstallDir)
{
    uninstallCanceled = false;

    if (checkForConnection()) {
		MessageBox(hwndParent, L"Mobile Application Link cannot be removed while your device is connected.", L"Remove Mobile Application Link", MB_OK);

        uninstallCanceled = true;

        return codeUNINSTALL_INIT_CANCEL;
    }

    if (checkForRunningClient(hwndParent) == CANCEL) {
        uninstallCanceled = true;

        return codeUNINSTALL_INIT_CANCEL;
    }

    agPreUninstall();

    return codeUNINSTALL_INIT_CONTINUE;
}

codeUNINSTALL_EXIT Uninstall_Exit(HWND hwndParent)
{
    if (!uninstallCanceled)
        agPostUninstall();

    return codeUNINSTALL_EXIT_DONE;
}
