// mobilelink.cpp : Defines the entry point for the application.
// Copyright 1998, 1999 AvantGo, Inc.  All rights reserved.
// Owner:  jason

#include <mobilelink.h>
#include <MobileLinkResource.h>
#include <MainWindow.h>
#include <ChildWindow.h>
#include <AGUtil.h>
#include <commctrl.h>

AGBool running = FALSE;

BOOL CheckForPreviousInstance()
{
    if (running) {
        HWND hwnd = FindWindow(MainWindowGetClassName(), NULL);

        if (IsWindow(hwnd)) {
            SetForegroundWindow(hwnd);
            ShowWindow(hwnd, SW_SHOWNORMAL);
        }
        return TRUE;
    }

    return FALSE;
}

int WINAPI WinMain(HINSTANCE hInst,
                     HINSTANCE hPrevInst,
                     LPWSTR     lpCmdLine,
                     int       nCmdShow)
{

    int ret = 0;

    // Check to see if we're already running.
    if (CheckForPreviousInstance())
        return ret;

    // Be sure Windows common controls are available.
    INITCOMMONCONTROLSEX initControlsEX;

    InitCommonControls();
    initControlsEX.dwSize = sizeof(INITCOMMONCONTROLSEX);
    initControlsEX.dwICC = ICC_COOL_CLASSES | ICC_BAR_CLASSES;
    InitCommonControlsEx(&initControlsEX);

    running = TRUE;

    __try {

        MSG msg;
        HACCEL haccel = NULL;
        HWND hWnd, childWnd;

        // Create the main window.  This window will be invisible.
        hWnd = MainWindowCreate(hInst);

        HWND hwndCB = CommandBar_Create(hInst, hWnd, IDC_CMDBAR);
        CommandBar_InsertMenubar(hwndCB, hInst, IDR_MAIN_MENU, 0);
        CommandBar_AddAdornments(hwndCB, 0, 0);

        if (NULL == hWnd)
            __leave;

        childWnd = ChildWindowCreate(hInst, hWnd);

        if (!childWnd)
            __leave;

        // temp
        int commandBarHeight = CommandBar_Height(GetDlgItem(hWnd, IDC_CMDBAR));
        RECT clientRect = {0, 0, 0, 0};
        GetClientRect(hWnd, &clientRect);
        SetWindowPos(childWnd, NULL, clientRect.left, clientRect.top + commandBarHeight,
            clientRect.right - clientRect.left, clientRect.bottom - clientRect.top - commandBarHeight, SWP_NOZORDER);

        ShowWindow(hWnd, nCmdShow);
        UpdateWindow(hWnd);

        ShowWindow(childWnd, nCmdShow);
        UpdateWindow(childWnd);

        // Standard windows event loop.
        while (GetMessage(&msg, NULL, 0, 0)) {
            if (!TranslateAccelerator(msg.hwnd, haccel, &msg)) {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
            }
        }

        // If we got here, we got a WM_QUIT message and wParam contains
        // any result code.
        ret = msg.wParam;
    } __finally {
    }

    return ret;
}