// MainWindow.cpp
// Copyright 1998, 1999 AvantGo, Inc.  All rights reserved.
// Owner:  jason

#include <MainWindow.h>
#include <MainDialog.h>
#include <mobilelink.h>
#include <MobileLinkResource.h>
#include <afxres.h>
#include <windowsx.h>
#include <commctrl.h>

// Window class names won't ever be localized so we don't bother sticking them
// in a resource file.
#define CLASS_NAME L"AvantGo Mobile Link Main Window Class"

typedef struct mwWindowInfo {

    HWND hwnd;
    ATOM classAtom;

} mwWindowInfo;

// ----------------------------------------------------------------------------
static BOOL WMCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct)
{
    // TRUE == success.  This is the opposite of the correct return code
    // for a successful WM_CREATE handling, but the windowsx message cracker
    // flips the value.
    return TRUE;
}

// ----------------------------------------------------------------------------
static void WMDestroy(HWND hwnd)
{
}

// ----------------------------------------------------------------------------
static BOOL WMEraseBkgnd(HWND hwnd, HDC hdc)
{
    // Simply return false to mark that the usual WM_PAINT handler should handle
    // the background erasing.
    return FALSE;
}

// ----------------------------------------------------------------------------
static void WMPaint(HWND hwnd)
{
    PAINTSTRUCT ps;
    RECT r;

    BeginPaint(hwnd, &ps);
    GetClientRect(hwnd, &r);
    FillRect(ps.hdc, &r, GetSysColorBrush(COLOR_WINDOW));
    EndPaint(hwnd, &ps);
}

static void WMClose(HWND hwnd)
{
    DestroyWindow(hwnd);

    PostQuitMessage(0);
}

static LRESULT IDFileClose(HWND hwnd, HWND hwndCtl)
{
    SendMessage(hwnd, WM_CLOSE, 0, 0);
    return 0;
}

// ----------------------------------------------------------------------------
static LRESULT WMCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    switch (id) {
        HANDLE_COMMAND(hwnd, ID_FILE_CLOSE, hwndCtl, codeNotify, IDFileClose);
    }

    return 0;
}

// ----------------------------------------------------------------------------
static LRESULT CALLBACK wndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_CREATE,     WMCreate);
        HANDLE_MSG(hwnd, WM_DESTROY,    WMDestroy);
        HANDLE_MSG(hwnd, WM_ERASEBKGND, WMEraseBkgnd);
        HANDLE_MSG(hwnd, WM_PAINT,      WMPaint);
        HANDLE_MSG(hwnd, WM_CLOSE,      WMClose);
        HANDLE_MSG(hwnd, WM_COMMAND,    WMCommand);
    }

    return DefWindowProc(hwnd, message, wParam, lParam);
}

// ----------------------------------------------------------------------------
LPTSTR MainWindowGetClassName(void)
{
    return CLASS_NAME;
}

// ----------------------------------------------------------------------------
HWND MainWindowCreate(HINSTANCE hInst)
{
    WNDCLASS wc;

    wc.style = 0;
    wc.lpfnWndProc = (WNDPROC)wndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hIcon = NULL;
    wc.hInstance = hInst;
    wc.hCursor = NULL;
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = CLASS_NAME;
    
    RegisterClass(&wc);

    return CreateWindow(CLASS_NAME,
                        CLASS_NAME,
                        WS_VISIBLE | WS_SYSMENU,
                        0, 0,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        NULL, NULL, hInst, NULL);
}