// ChildWindow.cpp
// Copyright 1998, 1999 AvantGo, Inc.  All rights reserved.
// Owner:  jason

#include <ChildWindow.h>
#include <MobileLinkResource.h>
#include <mobilelink.h>
#include <windowsx.h>
#include <commctrl.h>
#include <AGUtil.h>
//#include <MALSyncCEDevice.h>

// Window class names won't ever be localized so we don't bother sticking them
// in a resource file.
#define CLASS_NAME L"AvantGo Mobile Link Child Window Class"

typedef void (CALLBACK * SyncAllServersFunc)();

SyncAllServersFunc SyncAllServers;

typedef struct mwWindowInfo {
    HWND hwnd;
    ATOM classAtom;
} mwWindowInfo;

// ----------------------------------------------------------------------------
static BOOL WMCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct)
{
    // TRUE == success.  This is the opposite of the correct return code
    // for a successful WM_CREATE handling, but the windowsx message cracker
    // flips the value.
    return TRUE;
}

// ----------------------------------------------------------------------------
static void WMDestroy(HWND hwnd)
{
}

// ----------------------------------------------------------------------------
static BOOL WMEraseBkgnd(HWND hwnd, HDC hdc)
{
    // Simply return false to mark that the usual WM_PAINT handler should handle
    // the background erasing.
    return FALSE;
}

// ----------------------------------------------------------------------------
static void WMPaint(HWND hwnd)
{
    PAINTSTRUCT ps;
    RECT r;

    BeginPaint(hwnd, &ps);
    GetClientRect(hwnd, &r);
    FillRect(ps.hdc, &r, GetSysColorBrush(COLOR_WINDOW));
    EndPaint(hwnd, &ps);
}

static LRESULT IDSynchronize(HWND hwnd, HWND hwndCtl)
{
#define DUH
#ifdef DUH
#define SyncAllServers MALSyncAllServers
#else
    HMODULE dll = LoadLibrary(L"\\windows\\malclmgr.dll");

    SyncAllServers = (SyncAllServersFunc)GetProcAddress(dll, L"MALSyncAllServers");
#endif

//    (*SyncAllServers)();

    return 0;
}

// ----------------------------------------------------------------------------
static LRESULT WMCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    switch (id) {
        HANDLE_COMMAND(hwnd, ID_SYNCHRONIZE, hwndCtl, codeNotify, IDSynchronize);
    }

    return 0;
}

// ----------------------------------------------------------------------------
static LRESULT CALLBACK wndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_CREATE,     WMCreate);
        HANDLE_MSG(hwnd, WM_DESTROY,    WMDestroy);
        HANDLE_MSG(hwnd, WM_ERASEBKGND, WMEraseBkgnd);
        HANDLE_MSG(hwnd, WM_PAINT,      WMPaint);
        HANDLE_MSG(hwnd, WM_COMMAND,    WMCommand);
        return 0;
    }

    return DefWindowProc(hwnd, message, wParam, lParam);
}

// ----------------------------------------------------------------------------
LPTSTR MainWindowGetClassName(void)
{
    return CLASS_NAME;
}

// ----------------------------------------------------------------------------
HWND ChildWindowCreate(HINSTANCE hInst, HWND hWnd)
{
    return CreateDialog(hInst, MAKEINTRESOURCE(IDD_TEST), hWnd, (DLGPROC)wndProc);
}