/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#include <windows.h>
#include <AGSyncCEDesktop.h>

CDataHandler::CDataHandler( void )
{
}

CDataHandler::~CDataHandler()
{
}

/*++
--*/
STDMETHODIMP CDataHandler::QueryInterface( REFIID iid, LPVOID  *ppvObj )
{
    *ppvObj = NULL;   // set to NULL, in case we fail.

    if ( IsEqualIID( iid, IID_IUnknown ) )
        *ppvObj = (void*)this;

    if ( *ppvObj )
    {
        ((IUnknown *)(*ppvObj))->AddRef();
        return NOERROR;
    }
    return E_NOINTERFACE;
}

/*++
--*/
STDMETHODIMP_(ULONG) CDataHandler::AddRef()
{
    // don't need reference counting
    return 0;
}

/*++
--*/
STDMETHODIMP_(ULONG) CDataHandler::Release()
{
    // don't need reference counting
    return 0;
}


//
//
//

/*++
--*/
STDMETHODIMP CDataHandler::Setup
( 
    PREPLSETUP pSetup   // Points to REPLSETUP, which has information about the object to be serialized/deserialized
)
{
    return NOERROR;
}

/*++
--*/
STDMETHODIMP CDataHandler::GetPacket
( 
    LPBYTE  *lppbPacket, 
    DWORD   *pcbPacket, 
    DWORD   cbRecommend 
)
{
    // Not implemented, so simply return RERR_BAD_OBJECT
    return RERR_BAD_OBJECT;
}


/*++
--*/
STDMETHODIMP CDataHandler::SetPacket( LPBYTE lpbPacket, DWORD cbPacket )
{
    // Not implemented, so simply return RERR_BAD_OBJECT

    // if a new item is to be created, the REPLSETUP::hItem (passed in Setup call) will be NULL
    // and you need to create a new HREPLITEM for the new object you will created here
    // be sure to assign correct item ID as well as time stamp in this new handle
    return RERR_BAD_OBJECT;
}

/*++
--*/
STDMETHODIMP CDataHandler::DeleteObj
( 
    PREPLSETUP  pSetup
)
{
    // Not implemented, so simply return RERR_SKIP_ALL
    return RERR_SKIP_ALL;
}


/*++
--*/
STDMETHODIMP CDataHandler::Reset
( 
    PREPLSETUP pSetup   // Points to REPLSETUP, which has information about the object just serialized/deserialized
)
{
    return NOERROR;
}

