/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#ifndef __AGSYNCCESTATUSDIALOG_H__
#define __AGSYNCCESTATUSDIALOG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <windows.h>
#include <AGArray.h>

typedef struct AGSyncCEStatusDialog {
    HWND hDlg;
    HWND hTask;
    HWND hItem;
    HWND hBar;
    HWND hx_of_y;
    TCHAR * x_of_y;
    AGArray * graphic;
    uint32 currentFrame;
    uint32 msecPerFrame;
    AGBool bitmapFormat;
    AGBool * quit;
} AGSyncCEStatusDialog;

AGSyncCEStatusDialog * AGSyncCEStatusDialogNew(HINSTANCE hInst,
                                               AGBool * quit,
                                               AGArray * graphic,
                                               uint32 msecPerFrame,
                                               AGBool bitmapFormat);
void AGSyncCEStatusDialogFree(AGSyncCEStatusDialog * pInfo);
void AGSyncCEStatusDialogSetTask(AGSyncCEStatusDialog * pInfo, LPCSTR str);
void AGSyncCEStatusDialogSetTitle(AGSyncCEStatusDialog * pInfo,
                                  LPCSTR str);
void AGSyncCEStatusDialogSetItem(AGSyncCEStatusDialog * pInfo, LPCSTR str);
void AGSyncCEStatusDialogSetBar(AGSyncCEStatusDialog * pInfo,
                                int progress, int maximum);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* #ifndef __AGSYNCCESTATUSDIALOG_H__ */