/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#include <AGSyncCEDeviceExportFunctions.h>
#include <AGSyncCEDeviceDataHandler.h>

/* ----------------------------------------------------------------------------
    BOOL WINAPI DllMain (HANDLE hInst, ULONG ulReason, LPVOID lpReserved)

    Standard entry point for DLL.

*/
BOOL WINAPI DllMain (HANDLE hInst, ULONG ulReason, LPVOID lpReserved)
{
    return TRUE;
}

/* ----------------------------------------------------------------------------
    ExportFunc BOOL InitObjType(LPWSTR lpszObjType,
                                IReplObjHandler **ppObjHandler,
                                UINT uPartnerBit)

    One of the required exported functions for an ActiveSync device client.

*/
ExportFunc BOOL InitObjType(LPWSTR lpszObjType,
                            IReplObjHandler **ppObjHandler,
                            UINT uPartnerBit)
{
    if (lpszObjType == NULL)
        return TRUE;
    *ppObjHandler = new CDataHandler;
    return TRUE;
}

/* ----------------------------------------------------------------------------
    ExportFunc BOOL ObjectNotify(POBJNOTIFY pNotify)

    One of the required exported functions for an ActiveSync device client.

*/
ExportFunc BOOL ObjectNotify(POBJNOTIFY pNotify)
{
    if (pNotify->cbStruct != sizeof(OBJNOTIFY))
        return FALSE;
    pNotify->poid = (UINT *)&pNotify->oidObject;
    return TRUE;
}

/* ----------------------------------------------------------------------------
    ExportFunc BOOL GetObjTypeInfo(POBJTYPEINFO pInfo)

    One of the required exported functions for an ActiveSync device client.

*/
ExportFunc BOOL GetObjTypeInfo(POBJTYPEINFO pInfo)
{
    if (pInfo->cbStruct != sizeof(OBJTYPEINFO))
        return FALSE;

    return TRUE;
}

/* ----------------------------------------------------------------------------
    ExportFunc BOOL ReportStatus(LPWSTR lpszObjType, UINT uCode,UINT uParam)

    One of the required exported functions for an ActiveSync device client.

*/
ExportFunc BOOL ReportStatus(LPWSTR lpszObjType, UINT uCode,UINT uParam)
{
    switch(uCode)
    {
    case RSC_BEGIN_SYNC:
        break;

    case RSC_END_SYNC:
        break;
    }
    return TRUE;
}
