/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#include <AGSyncCEDeviceDataHandler.h>

CDataHandler::CDataHandler()
{
    m_cRef  = 1;
}

CDataHandler::~CDataHandler()
{
}

STDMETHODIMP_(ULONG) CDataHandler::AddRef()
{
    ULONG urc;
    urc = (ULONG)InterlockedIncrement( &m_cRef );
    return(urc);
}

STDMETHODIMP_(ULONG) CDataHandler::Release()
{
    ULONG urc;
    urc = (ULONG)InterlockedDecrement( &m_cRef ); 
    if (urc == 0 ) 
        delete this;

    return urc;
}

STDMETHODIMP CDataHandler::QueryInterface( REFIID iid, LPVOID  *ppvObj )
{
    *ppvObj = NULL;
    return E_NOINTERFACE;
}

STDMETHODIMP CDataHandler::Reset( PREPLSETUP pSetup )
{
    return NOERROR;
}

STDMETHODIMP CDataHandler::Setup( PREPLSETUP pSetup )
{
    return NOERROR;
}

STDMETHODIMP CDataHandler::DeleteObj( PREPLSETUP pSetup )
{
    return NOERROR;
}

STDMETHODIMP CDataHandler::GetPacket(LPBYTE *lppbPacket,
                                     DWORD *pcbPacket,
                                     DWORD cbRecommend)
{
    return E_NOTIMPL;
}

STDMETHODIMP CDataHandler::SetPacket( LPBYTE lpbPacket, DWORD cbPacket )
{
    return E_NOTIMPL;
}