/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#ifndef __AGSYNCCEDEVICECOMMON_H__
#define __AGSYNCCEDEVICECOMMON_H__

#include <windows.h>
#include <cesync.h>

#ifndef ExportFunc
#define ExportFunc __declspec( dllexport )
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <AGTypes.h>
    
struct AGRecord;
struct AGDBConfig;
struct AGReader;
struct AGWriter;
struct AGServerConfig;
struct AGUserConfig;
struct AGSyncCEDeviceDLLManager;

typedef struct SyncInfo {

    AGBool streamDone;
    AGRecord * record;
    AGDBConfig * currentDb;
    AGReader * reader;
    AGWriter * writer;
    AGServerConfig * currentServerConfig;
    AGUserConfig * userConfig;
    AGSyncCEDeviceDLLManager * dll;

} SyncInfo;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* #ifndef __AGSYNCCEDEVICECOMMON_H__ */