/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/*  Owner:  miket */

#ifndef __AGSYNCCEDEVICE_H__
#define __AGSYNCCEDEVICE_H__

#include <AGSyncCEDeviceCommon.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum tagRAPISTREAMFLAG
{
    STREAM_TIMEOUT_READ
} RAPISTREAMFLAG;

DECLARE_INTERFACE_ (IRAPIStream, IStream)
{
    STDMETHOD(SetRapiStat)(THIS_ RAPISTREAMFLAG Flag, DWORD dwValue) PURE;
    STDMETHOD(GetRapiStat)(THIS_ RAPISTREAMFLAG Flag, DWORD *pdwValue) PURE;
};

typedef HRESULT (STDAPICALLTYPE RAPIEXT) (DWORD cbInput,
                                          BYTE *pInput,
                                          DWORD *pcbOutput,
                                          BYTE **ppOutput,
                                          IRAPIStream *pIRAPIStream);

/* Take a stream of wrapped MAL commands, interpret them if necessary,
 and pass them to the appropriate client DLL to handle them. */
ExportFunc RAPIEXT _RAPI_HandleStream;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* #ifndef __AGSYNCCEDEVICE_H__ */