/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGMobileLinkNet.h>
#include <AGMD5.h>
#include <AGConfigUtil.h>
#include <AGXMLSubmitter.h>
#include <AGProtocol.h>
#include <AGClientProcessor.h>
#include <AGCommandProcessor.h>
#include <AGBufferWriter.h>
#include <AGConfigResource.h>
#include <AGProgressDialog.h>
#include <AGSyncCommon.h>
#include <AGShlapi.h>

#define kNoWrapper "%s"
#define kAvantGoSubXMLWrapper "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\
<!DOCTYPE avantgo_subs_file [ \
<!ELEMENT sub (#PCDATA)>\
]>\
<sub>%s</sub>"
#define kSubmissionURI "/sync/sub"
#define kSubSubmissionGoodMessage "Subs file submitted successfully"
#define kSubmissionGoodMessage "File submitted successfully"

typedef struct {

    AGBool sentCommand;
    AGBool receivedAck;
    AGBool serverUpdatedDialog;
    char * buffer;
    long bufferSize;
    AGCommandProcessor * cp;
    AGClientProcessor * clientProcessor;
    AGPlatformCalls * platformCalls;
    AGLocationConfig * locationConfig;
    AGServerConfig * serverConfig;
    AGProgressDialog * progressDialog;

} subState;

/* Disallow multiple subs files to be sent at once. */
static AGBool reentrant = FALSE;

extern HINSTANCE g_hInstance;

/* ----------------------------------------------------------------------------
*/
static int32 getNextCommand(void *out,
                            int32 *newCommand,
                            int32 *commandLength,
                            void **commandBytes)
{
    subState *state = (subState *)out;

    if(!state->sentCommand) {
        AGBufferWriter writer;

        state->sentCommand = TRUE;

        AGBufferWriterInit(&writer, 512);
        AGWriteCompactInt((AGWriter *)&writer, state->bufferSize);
        AGWriteBytes((AGWriter *)&writer, state->buffer, state->bufferSize);

        *newCommand = (int32)AG_XMLDATA_CMD;
        *commandLength = AGBufferWriterGetBufferSize(&writer);
        *commandBytes = AGBufferWriterGetBuffer(&writer);
        writer.buffer = NULL;
        AGBufferWriterFinalize(&writer);

        return AGCLIENT_CONTINUE;

    } else
        return AGCLIENT_IDLE;
}

/* ----------------------------------------------------------------------------
*/
static int32 handleGOODBYE(void *out,
                           int32 *returnErrorCode,
                           AGSyncStatus syncStatus,
                           int32 errorCode,
                           char *errorMessage)
{
    subState *state = (subState *)out;

    if (NULL != errorMessage) {

        char buffer[MAX_PATH];
        char * buf2;

        LoadString(g_hInstance,
            IDS_SUBS_PROGRESS_MESSAGE,
            buffer,
            MAX_PATH);

        buf2 = (char *)malloc(strlen(buffer) + strlen(errorMessage) + 1);

        if (NULL != buf2) {

            sprintf(buf2, buffer, errorMessage);

            AGProgressDialogUpdateText(state->progressDialog, buf2);

            state->serverUpdatedDialog = TRUE;

            free(buf2);

        }

        state->receivedAck =
            (!strcmp(errorMessage, kSubmissionGoodMessage)
            || !strcmp(errorMessage, kSubSubmissionGoodMessage));

    } else
        state->receivedAck = FALSE;


    return AGCLIENT_CONTINUE;
}

/* ----------------------------------------------------------------------------
*/
AGBool AGXMLSubmitterSubmit(HWND hwnd,
                            AGServerConfig * sc,
                            AGLocationConfig * loc,
                            char * bytes,
                            uint32 fileSize)
{
    subState state;
    uint32 timeToClose;
    AGBool userCancel;
    AGNetCtx ctx;
    char buffer[MAX_PATH];
    char * buf2;

    if (NULL == bytes)
        return FALSE;

    bzero(&state, sizeof(subState));

    state.bufferSize = fileSize;

    state.buffer = bytes;

    state.locationConfig = loc;

    state.serverConfig = AGServerConfigDup(sc);

    /* Set true to cancel the user. No, not really. */
    userCancel = FALSE;

    AGNetInit(&ctx);

    /* Send bytes to server. */

    /* pending(miket) put this somewhere else */
    if (NULL != state.serverConfig->serverUri)
        free(state.serverConfig->serverUri);
    state.serverConfig->serverUri = strdup(kSubmissionURI);

    state.cp = AGCommandProcessorNew(state.serverConfig);
    state.cp->commands.out = &state;
    state.cp->commands.performGoodbyeFunc = handleGOODBYE;

    state.platformCalls = malloc(sizeof(AGPlatformCalls));
    if (NULL != state.platformCalls) {

        bzero(state.platformCalls, sizeof(AGPlatformCalls));

        state.platformCalls->out = &state;
        state.platformCalls->nextExpansionCommandFunc =
            getNextCommand;

        state.platformCalls->performCommandOut = state.cp;
        state.platformCalls->performCommandFunc =
            AGCommandProcessorGetPerformFunc(state.cp);

    }

    LoadString(g_hInstance,
        IDS_SUBS_DETAIL_CONNECT,
        buffer,
        MAX_PATH);

    buf2 = (char*)malloc(1
        + strlen(buffer)
        + 16
        + strlen(state.serverConfig->serverName)
        + strlen(state.serverConfig->friendlyName));

    if (NULL != buf2) {

        sprintf(buf2, buffer, state.serverConfig->friendlyName,
            state.serverConfig->serverName,
            state.serverConfig->serverPort);

    }

    state.progressDialog = AGProgressDialogCreate(hwnd, buf2);

    do {

        state.clientProcessor = AGClientProcessorNew(state.serverConfig,
            NULL,
            state.locationConfig,
            state.platformCalls,
            TRUE,
            &ctx);

        state.serverConfig->sendDeviceInfo = FALSE;

        AGCommandProcessorStart(state.cp);

        AGClientProcessorSetBufferServerCommands(state.clientProcessor,
            TRUE);

        AGClientProcessorSync(state.clientProcessor);

        userCancel =
            (AGMobileLinkNetDoProcess(state.clientProcessor) < 0);

        AGClientProcessorFree(state.clientProcessor);

    } while (AGCommandProcessorShouldSyncAgain(state.cp)
        && !userCancel);

    AGProgressDialogStopMotion(state.progressDialog);

    if (!userCancel) {

        if (!state.serverUpdatedDialog) {

            LoadString(g_hInstance,
                IDS_SUBS_FAILED_MESSAGE,
                buffer,
                MAX_PATH);
            
            AGProgressDialogUpdateText(state.progressDialog, buffer);
        }

        AGProgressDialogChangeTerminatingButtonText(state.progressDialog,
            "&Close");

        timeToClose = GetTickCount() + 5000;
        while (!AGMobileLinkNetDoWindowsMessagePump(TRUE)
            && GetTickCount() < timeToClose)
            ;

    }

    AGProgressDialogTerminate(state.progressDialog);

    if (NULL != buf2)
        free(buf2);

    AGCommandProcessorFree(state.cp);

    free(state.platformCalls);

    AGNetClose(&ctx);

    return (state.receivedAck);
}

/* ----------------------------------------------------------------------------
*/
AGBool AGXMLSubmitterHandleFile(HWND hwnd,
                                LPSTR name,
                                AGBool isSubsFile,
                                AGUserConfig * userConfig)
{
    HANDLE hFile;
    AGBool submitResult = FALSE;

    hFile = CreateFile(name,
        GENERIC_READ,
        FILE_SHARE_READ,
        NULL,
        OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL, NULL);

    if (hFile != INVALID_HANDLE_VALUE) {

        long fileSize = GetFileSize(hFile, NULL);

        HANDLE hMapping = CreateFileMapping(hFile,
            NULL,
            PAGE_READONLY,
            0,
            0,
            NULL);

        if (NULL != hMapping) {

            char *data = NULL;
            char *dataMap;
            
            dataMap = (char *)MapViewOfFile(hMapping,
                FILE_MAP_READ,
                0,
                0,
                0);

            data = (char*)malloc(fileSize+1);

            if (NULL != dataMap) {

                if (NULL != data) {

                    memcpy(data, dataMap, fileSize);
                    data[fileSize] = '\0';

                }

                UnmapViewOfFile(data);

            }

            if (NULL != data) {

                uint32 xml_wrapped_data_size;
                char * xml_wrapped_data = NULL;

                if (isSubsFile) {
                    xml_wrapped_data_size = strlen(kAvantGoSubXMLWrapper)
                        + fileSize + 16;
                } else {
                    xml_wrapped_data_size = strlen(kNoWrapper)
                        + fileSize + 16;
                }
                xml_wrapped_data = (char*)malloc(xml_wrapped_data_size);

                if (NULL != xml_wrapped_data) {

                    AGLocationConfig * locationConfig;
                    char * stringConstant;
                    AGServerConfig * serverConfig = NULL;
                    AGUserConfigEnumerateState * eState = NULL;
                    AGBool alreadySent = FALSE;

                    sprintf(xml_wrapped_data,
                        (isSubsFile)
                        ? kAvantGoSubXMLWrapper
                        : kNoWrapper,
                        data);

                    stringConstant =
                        AGSyncCommonGetStringConstant(agLocationConfigPath,
                        FALSE);
                    locationConfig =
                        AGReadLocationConfigFromDisk(stringConstant);
                    free(stringConstant);

                    do {

                        serverConfig = AGUserConfigEnumerate(userConfig,
                            &eState);
                        if (alreadySent)
                            continue;
                        if (NULL == serverConfig)
                            continue;
                        if (!AGServerConfigIsValid(serverConfig))
                            continue;

                        /* It's ok to modify these fields because the
                        caller won't be writing them back to disk. */
                        strlwr(serverConfig->friendlyName);
                        strlwr(serverConfig->serverName);
                        if (NULL == strstr(serverConfig->friendlyName,
                            "avantgo")
                            && NULL == strstr(serverConfig->serverName,
                            "avantgo.com"))
                            continue;

                        /* We can't use the nonce that's already stored
                        from last sync, so use the data we're sending up
                        as a source for the nonce. */
                        AGMd5(xml_wrapped_data,
                            xml_wrapped_data_size,
                            serverConfig->nonce);

                        submitResult = AGXMLSubmitterSubmit(hwnd,
                            serverConfig,
                            locationConfig,
                            xml_wrapped_data,
                            xml_wrapped_data_size);

                        if (submitResult)
                            alreadySent = TRUE;

                    } while (NULL != serverConfig);

                    if (NULL != locationConfig)
                        AGLocationConfigFree(locationConfig);

                    free(xml_wrapped_data);

                }

                free(data);

            }

            CloseHandle(hMapping);

        }

        CloseHandle(hFile);

    }

    if (!submitResult) {

        char message[MAX_PATH*2];
        char title[MAX_PATH];

        LoadString(g_hInstance,
            IDS_SUBMIT_NO_SERVER_TITLE,
            title,
            MAX_PATH);
        LoadString(g_hInstance,
            IDS_SUBMIT_NO_SERVER,
            message,
            MAX_PATH*2);

        MessageBox(hwnd,
            message,
            title,
            MB_OK | MB_ICONWARNING);
    }

    return submitResult;
}

/* ----------------------------------------------------------------------------
*/
AGBool AGXMLSubmitterHandleFileForCurrentDevice(HWND hwnd,
                                                LPSTR name,
                                                AGBool isSubsFile)
{
    AGUserConfig * userConfig;
    AGBool submitResult = FALSE;
    char tempstring[MAX_PATH];
    AGConfigUtilGetCurrentUserConfigFilename(tempstring, NULL);
    userConfig = AGReadUserConfigFromDisk(tempstring);

    if (reentrant) {

        char caption[MAX_PATH];
        char message[MAX_PATH];

        LoadString(g_hInstance,
            IDS_NO_REENTRANT_SUBMISSION_CAPTION,
            caption,
            MAX_PATH);

        LoadString(g_hInstance,
            IDS_NO_REENTRANT_SUBMISSION_MESSAGE,
            message,
            MAX_PATH);

        MessageBox(hwnd, message, caption, MB_OK);

        return FALSE;

    }
    else
        reentrant = TRUE;

    if (NULL != userConfig) {

        submitResult = AGXMLSubmitterHandleFile(hwnd,
            name,
            isSubsFile,
            userConfig);

        AGUserConfigFree(userConfig);

    }

    reentrant = FALSE;

    return submitResult;
}
