/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <windowsx.h>
#include <AGConfig.h>
#include <AGConfigResource.h>
#include <AGProgressDialog.h>
#include <AGUtil.h>

/* ----------------------------------------------------------------------------
*/
void AGProgressDialogUpdateText(AGProgressDialog * progressDlg, char * newText)
{
    SetWindowText(GetDlgItem(progressDlg->hDialog, IDC_PROGRESS_DIALOG_TEXT),
        newText);
}

/* ----------------------------------------------------------------------------
*/
static void setMotionPosition(AGProgressDialog * progressDlg,
                              int degrees)
{
    int iconID;
    HWND hwndIcon;

    iconID = -1;
    switch (progressDlg->iconDegrees / 90) {
        case 0:
            iconID = IDI_APP_ICON;
            break;
        case 1:
            iconID = IDI_APP_ICON90;
            break;
        case 2:
            iconID = IDI_APP_ICON180;
            break;
        case 3:
            iconID = IDI_APP_ICON270;
            break;
    }

    hwndIcon = GetDlgItem(progressDlg->hDialog, IDC_PROGRESS_ICON);
    if (iconID >= 0)
        SendMessage(hwndIcon,
            STM_SETIMAGE,
            IMAGE_ICON,
            (LPARAM)LoadIcon(g_hInstance, MAKEINTRESOURCE(iconID)));

    if (progressDlg->dIconPosition.x) {

        RECT r;

        GetClientRect(progressDlg->hDialog, &r);

        progressDlg->iconPosition.x += progressDlg->dIconPosition.x;
        progressDlg->iconPosition.y += progressDlg->dIconPosition.y;

        if (progressDlg->iconPosition.x + progressDlg->iconSize.x > r.right) {
            progressDlg->iconPosition.x = r.right - progressDlg->iconSize.x;
            progressDlg->dIconPosition.x = - progressDlg->dIconPosition.x;
        }

        if (progressDlg->iconPosition.x < r.left) {
            progressDlg->iconPosition.x = r.left;
            progressDlg->dIconPosition.x = - progressDlg->dIconPosition.x;
        }

        if (progressDlg->iconPosition.y + progressDlg->iconSize.y > r.bottom) {
            progressDlg->iconPosition.y = r.bottom - progressDlg->iconSize.y;
            progressDlg->dIconPosition.y = - progressDlg->dIconPosition.y;
        }

        if (progressDlg->iconPosition.y < r.top) {
            progressDlg->iconPosition.y = r.top;
            progressDlg->dIconPosition.y = - progressDlg->dIconPosition.y;
        }

        MoveWindow(hwndIcon,
            progressDlg->iconPosition.x,
            progressDlg->iconPosition.y,
            progressDlg->iconSize.x,
            progressDlg->iconSize.y,
            TRUE);

    }
}

/* ----------------------------------------------------------------------------
*/
void AGProgressDialogStopMotion(AGProgressDialog * progressDlg)
{
    if (progressDlg->iconTimer != 0) {
        KillTimer(progressDlg->hDialog, 0);
        progressDlg->iconTimer = 0;
    }
    setMotionPosition(progressDlg, 0);
}

/* ----------------------------------------------------------------------------
*/
static void restartTimer(AGProgressDialog * progressDlg)
{
    progressDlg->iconTimer = SetTimer(progressDlg->hDialog,
        0,
        progressDlg->iconTimePeriod,
        NULL);
}

/* ----------------------------------------------------------------------------
*/
void AGProgressDialogStartMotion(AGProgressDialog * progressDlg)
{
    AGProgressDialogStopMotion(progressDlg);

    progressDlg->iconTimePeriod = 750;
    progressDlg->dIconDegrees = 90;

    if (0x8000 & GetAsyncKeyState(VK_CONTROL)) {

        HWND hwndIcon;
        RECT r;

        progressDlg->iconTimePeriod = 15;
        progressDlg->dIconDegrees = 2;

        hwndIcon = GetDlgItem(progressDlg->hDialog, IDC_PROGRESS_ICON);
        GetClientRect(hwndIcon, &r);
        progressDlg->iconSize.x = r.right;
        progressDlg->iconSize.y = r.bottom;

        GetWindowRect(hwndIcon, &r);

        progressDlg->iconPosition.x = r.left;
        progressDlg->iconPosition.y = r.top;
        ScreenToClient(progressDlg->hDialog, &progressDlg->iconPosition);

        progressDlg->dIconPosition.x = (rand() % 7) - 3;
        progressDlg->dIconPosition.y = (rand() % 7) - 3;
    }

    restartTimer(progressDlg);

}

/* ----------------------------------------------------------------------------
*/
static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    AGProgressDialog * progressDlg;

    SetWindowLong(hwnd, GWL_USERDATA, lParam);
    progressDlg = (AGProgressDialog *)GetWindowLong(hwnd, GWL_USERDATA);

    /* This gets set again a moment later but we need it now. */
    progressDlg->hDialog = hwnd;

    if (NULL != progressDlg->initialText)
        AGProgressDialogUpdateText(progressDlg, progressDlg->initialText);

    AGProgressDialogStartMotion(progressDlg);

    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static void onTimer(HWND hwnd, UINT id)
{
    AGProgressDialog * progressDlg;
    progressDlg = (AGProgressDialog *)GetWindowLong(hwnd, GWL_USERDATA);

    restartTimer(progressDlg);

    progressDlg->iconDegrees += progressDlg->dIconDegrees;
    progressDlg->iconDegrees %= 360;

    setMotionPosition(progressDlg, progressDlg->iconDegrees);
}

/* ----------------------------------------------------------------------------
*/
static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    AGProgressDialog * progressDlg =
        (AGProgressDialog *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case BN_CLICKED:
            switch (id) {
                case IDCANCEL: {
                    PostQuitMessage(0);
                    return;
                }
                default:
                    break;
            }
            break;
        default:
            break;

    }
}

/* ----------------------------------------------------------------------------
*/
static void onDestroy(HWND hwnd)
{
    AGProgressDialog * progressDlg;

    progressDlg = (AGProgressDialog *)GetWindowLong(hwnd, GWL_USERDATA);

    if (progressDlg->iconTimer != 0)
        KillTimer(hwnd, progressDlg->iconTimer);
}


/* ----------------------------------------------------------------------------
*/
static BOOL CALLBACK progressDialogProc(HWND hwnd,
                                        UINT message,
                                        WPARAM wParam,
                                        LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
        HANDLE_MSG(hwnd, WM_DESTROY, onDestroy);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
        HANDLE_MSG(hwnd, WM_TIMER, onTimer);
    }

    return 0;   /* except for WM_INITDIALOG, returning zero means
                we didn't process the message. */
}

/* ----------------------------------------------------------------------------
*/
AGProgressDialog * AGProgressDialogCreate(HWND parentHwnd,
                                          char * initialText)
{
    AGProgressDialog * result;

    result = (AGProgressDialog *)malloc(sizeof(AGProgressDialog));
    if (NULL != result) {

        bzero(result, sizeof(AGProgressDialog));

        result->initialText = initialText;

        result->hDialog = CreateDialogParam(g_hInstance,
            MAKEINTRESOURCE(IDD_PROGRESS_DIALOG),
            parentHwnd,
            progressDialogProc,
            (LPARAM)result);

    }

    return result;
}

/* ----------------------------------------------------------------------------
*/
void AGProgressDialogTerminate(AGProgressDialog * progressDialog)
{
    DestroyWindow(progressDialog->hDialog);
    free(progressDialog);
}

/* ----------------------------------------------------------------------------
*/
void AGProgressDialogChangeTerminatingButtonText(
    AGProgressDialog * progressDialog,
    char * newText)
{
    SetWindowText(GetDlgItem(progressDialog->hDialog, IDCANCEL), newText);
}
