/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGMobileLinkNet.h>

/* ----------------------------------------------------------------------------
    AGBool AGMobileLinkNetDoWindowsMessagePump(BOOL eatQuit)

    returns TRUE only if WM_QUIT message was posted.

    if eatQuit is FALSE, we post another nearly identical quit message after
    seeing one.
    
*/
AGBool AGMobileLinkNetDoWindowsMessagePump(BOOL eatQuit)
{
    MSG msg;
    while (PeekMessage(&msg, 0, 0, 0, PM_REMOVE | PM_NOYIELD)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        if (msg.message == WM_QUIT) {
            if (!eatQuit)
                PostQuitMessage((int)msg.wParam);
            return TRUE;
        }
    }
    return FALSE;
}

/* ----------------------------------------------------------------------------
*/
int32 AGMobileLinkNetDoProcess(AGClientProcessor * clientProcessor)
{
    int32 cpResult;
    AGBool quit = FALSE;
    
    do {
        cpResult = AGClientProcessorProcess(clientProcessor);
        if (AGMobileLinkNetDoWindowsMessagePump(TRUE)) {
            cpResult = AGCLIENT_IDLE;
            quit = TRUE;
        }
    } while (AGCLIENT_CONTINUE == cpResult);

    if (quit)
        return -1;
    else
        return cpResult;
}