/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGConnectionTesterUI.h>
#include <AGConfigProxySearch.h>
#include <AGSyncCommon.h>

/*PENDING(miket) There is a duplicate enumeration in AG DLL. Eliminate it.*/
enum {
    agFailed = 0,
    agDirect,
    agCurrent,
    agBrowser
};

void AGConnectionTesterUIDo(HWND hwnd,
                            AGServerConfig * sc)
{
    char * stringPointer;
    HMODULE hDLL;
    char oldPath[MAX_PATH];
    char * libName, * libPath;
    AGLocationConfig * lc;

    /* Load the proxy settings. */
    stringPointer = (char*)AGSyncCommonGetStringConstant(agLocationConfigPath,
        FALSE);
    lc = AGReadLocationConfigFromDisk(stringPointer);
    if (NULL == lc)
        lc = AGLocationConfigNew();

    libName = (char*)
        AGSyncCommonGetStringConstant(agExtensionDLLName, FALSE);
    libPath = (char*)
        AGSyncCommonGetStringConstant(agExtensionDLLPath, FALSE);

    if (NULL != libPath) {
        GetCurrentDirectory(MAX_PATH, oldPath);
        SetCurrentDirectory(libPath);
    }
    else
        oldPath[0] = '\0';

    if (NULL != libName) {
        hDLL = LoadLibrary(libName);
        if (NULL != hDLL) {
            typedef int (*ctFuncType)(HWND hwndParent,
                AGServerConfig * serverConfig,
                AGBool testDirect,
                AGLocationConfig * currentLC,
                AGLocationConfig * browserLC,
                AGBool * locationConfigChanged);
            ctFuncType ctfp;
            AGBool lcChanged = FALSE;
            AGLocationConfig * browserloc;
            int testResult = -1;

            browserloc = AGLocationConfigNew();
            AGConfigSearchBrowserSettings(browserloc);
            ctfp = (ctFuncType)GetProcAddress(hDLL, "Test");
            if (NULL != ctfp) {
                testResult = ctfp(hwnd,
                    sc,
                    TRUE,
                    lc,
                    browserloc,
                    &lcChanged);

                switch (testResult) {

                    case agFailed:
                        break;
                    case agDirect:
                        if (lc)
                            AGLocationConfigFree(lc);
                        lc = AGLocationConfigNew();
                        if (lc)
                            AGWriteLocationConfigToDisk(stringPointer,
                                lc);
                        break;
                    case agCurrent:
                        break;
                    case agBrowser:
                        AGWriteLocationConfigToDisk(stringPointer,
                            browserloc);
                        break;

                }

            }

            if (NULL != browserloc)
                AGLocationConfigFree(browserloc);
            FreeLibrary(hDLL);
        }
    }
    
    if (strlen(oldPath) > 0)
        SetCurrentDirectory(oldPath);

    if (NULL != libPath)
        free(libPath);
    if (NULL != libName)
        free(libName);

    if (NULL != lc)
        AGLocationConfigFree(lc);
    free(stringPointer);
}
