/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGServerPing.h>
#include <AGDigest.h>
#include <AGUtil.h>
#include <AGMD5.h>
#include <AGBase64.h>
#include <AGUserConfig.h>
#include <AGSyncCommon.h>
#include <stdlib.h>
#include <stdio.h>
#include <windowsx.h>
#include <AGConfigResource.h>
#include <AGConfigUtil.h>
#include <AGConfig.h>
#include <AGXMLSubmitter.h>
#include <AGDeviceUserDropDown.h>
#include <AGConfigDialogBase.h>
#include <AGConfigProxySearch.h>
#include <AGProgressDialog.h>
#include <AGUserChooser.h>
#include <AGConnectionTesterUI.h>

/* pending(miket): comment out if we're statically linking these. */
/*#ifdef _WIN32
#define XMLTOKAPI   __declspec(dllimport) 
#define XMLPARSEAPI __declspec(dllimport)
#else*/
#define XMLTOKAPI    
#define XMLPARSEAPI
/*#endif*/
#include <xmlparse.h>

#define kAvantGoServerURI "/sync/sub"
#define kAvantGoServerGoodMessage "Subs file submitted successfully"

LRESULT CALLBACK serverProc(HWND, UINT, WPARAM, LPARAM);

extern HWND hMainDialog;
extern HINSTANCE g_hInstance;

typedef struct Glue {
    AGServerConfig * config;
    char ** confirmCaption;
    char ** confirmMessage;
    AGBool passwordIsHashed;
    AGBool passwordIsEncoded;
} Glue;

typedef struct tagconfirmStruct {
    char * confirmmessage;
    char * confirmcaption;
    AGServerConfig * sc;
} confirmStruct;

/* ----------------------------------------------------------------------------
*/
void xmlElement(void *userData, const char *name, const char **atts)
{
    Glue *glue;
    int i = 0;
    char *attr;

    glue = (Glue *)userData;
    if (stricmp("MALServer", name) == 0) {
        while (atts[i] != 0) {
            attr = (char *)atts[i++];
            if (stricmp("hostname", attr) == 0) {
                if (glue->config->serverName != NULL)
                    free(glue->config->serverName);
                glue->config->serverName = strdup(atts[i++]);
            } else if (stricmp("port", attr) == 0) {
                glue->config->serverPort = atoi(atts[i++]);
            } else if (stricmp("username", attr) == 0) {
                if (glue->config->userName != NULL)
                    free(glue->config->userName);
                glue->config->userName = strdup(atts[i++]);
            } else if (stricmp("password", attr) == 0) {
                if (glue->config->cleartextPassword != NULL)
                    free(glue->config->cleartextPassword);
                glue->config->cleartextPassword = strdup(atts[i++]);
            } else if (stricmp("passwordIsHashed", attr) == 0) {
                if (stricmp("TRUE", atts[i++]) == 0)
                    glue->passwordIsHashed = TRUE;
                else
                    glue->passwordIsHashed = FALSE;
            } else if (stricmp("passwordIsEncoded", attr) == 0) {
                if (stricmp("TRUE", atts[i++]) == 0)
                    glue->passwordIsEncoded = TRUE;
                else
                    glue->passwordIsEncoded = FALSE;
            } else if (stricmp("disabled", attr) == 0) {
                if (stricmp("TRUE", atts[i++]) == 0)
                    glue->config->disabled = TRUE;
                else
                    glue->config->disabled = FALSE;
            } else if (stricmp("friendlyName", attr) == 0) {
                if (glue->config->friendlyName != NULL)
                    free(glue->config->friendlyName);
                glue->config->friendlyName = strdup(atts[i++]);
            } else if (stricmp("userUrl", attr) == 0) {
                if (glue->config->userUrl != NULL)
                    free(glue->config->userUrl);
                glue->config->userUrl = strdup(atts[i++]);
            } else if (stricmp("description", attr) == 0) {
                if (glue->config->description != NULL)
                    free(glue->config->description);
                glue->config->description = strdup(atts[i++]);
            } else if (stricmp("serverUri", attr) == 0) {
                if (glue->config->serverUri != NULL)
                    free(glue->config->serverUri);
                glue->config->serverUri = strdup(atts[i++]);
            } else if (stricmp("sendDeviceInfo", attr) == 0) {
                if (stricmp("TRUE", atts[i++]) == 0)
                    glue->config->sendDeviceInfo = TRUE;
                else
                    glue->config->sendDeviceInfo = FALSE;
            } else if (stricmp("hashPassword", attr) == 0) {
                if (stricmp("TRUE", atts[i++]) == 0)
                    glue->config->hashPassword = TRUE;
                else
                    glue->config->hashPassword = FALSE;
            } else if (stricmp("confirmation", attr) == 0) {
                if (*glue->confirmMessage != NULL)
                    free(*glue->confirmMessage);
                *glue->confirmMessage = strdup(atts[i++]);
            } else if (stricmp("confirmationcaption", attr) == 0) {
                if (*glue->confirmCaption != NULL)
                    free(*glue->confirmCaption);
                *glue->confirmCaption = strdup(atts[i++]);
            }
        }
    } else {
        while (atts[i] != 0) {
            puts(atts[i++]);
            putchar('\t');
            puts(atts[i++]);
        }
    }


}

static int32 readConfigFromFile(char *filename, 
                                AGServerConfig *serverConfig,
                                char ** confirmCaption,
                                char ** confirmMessage)
{
    char buffer[BUFSIZ];
    XML_Parser parser;
    Glue *glueData;
    FILE *stream;
    int32 done;
    AGBool errored = FALSE;

    stream = fopen(filename, "rb");
    if (stream == NULL)
        return -1;

    glueData = (Glue *)malloc(sizeof(Glue));
    bzero(glueData, sizeof(Glue));
    glueData->config = serverConfig;
    parser = XML_ParserCreate(NULL);
    XML_SetUserData(parser, glueData);
    XML_SetElementHandler(parser, xmlElement, NULL);

    glueData->confirmCaption = confirmCaption;
    glueData->confirmMessage = confirmMessage;

    do {
        size_t len = fread(buffer, 1, sizeof(buffer), stream);
        if (ferror(stream)) {
            errored = TRUE;
            break;
        }
        done = len < sizeof(buffer);
        if (!XML_Parse(parser, buffer, len, done)) {
            errored = TRUE;
            break;
        }
    } while (!done);

    XML_ParserFree(parser);

    if (glueData->passwordIsEncoded) {

        char * decoded;
        int len;

        decoded = AGBase64Decode(glueData->config->cleartextPassword,
            &len);

        if (glueData->config->hashPassword && !glueData->passwordIsHashed) {

            AGMd5(decoded, len, glueData->config->password);

            if (glueData->config->cleartextPassword != NULL) {
                free(glueData->config->cleartextPassword);
                glueData->config->cleartextPassword = NULL;
            }

        }
        free(decoded);

    } else {

        if (glueData->config->hashPassword) {

            AGMd5(glueData->config->cleartextPassword,
                strlen(glueData->config->cleartextPassword),
                glueData->config->password);

            if (glueData->config->cleartextPassword != NULL) {
                free(glueData->config->cleartextPassword);
                glueData->config->cleartextPassword = NULL;
            }

        }

    }

    free(glueData);

    fclose(stream);
    if (errored) {
        return -1;
    }
    return 0;
}

/* ----------------------------------------------------------------------------
*/
static AGBool addServerToUserConfigFile(AGServerConfig * serverConfig,
                                        char * filename,
                                        AGBool confirm)
{
    AGBool addServer = FALSE;
    AGBool result = FALSE;

    if (confirm && AGConfigUtilIsServerInList(filename,
        serverConfig->serverName,
        serverConfig->serverPort)) {

        if (AGConfigUtilDisplayDuplicateErrorMessage(NULL, FALSE) == IDOK) {

            AGConfigUtilRemoveServerFromUserConfigFile(
                serverConfig->serverName,
                serverConfig->serverPort,
                filename);

            addServer = TRUE;

        }

    } else
        addServer = TRUE;

    if (addServer) {

        AGConfigUtilAddServerToUserConfigFile(serverConfig,
            filename);

        result = TRUE;

        if (NULL != hMainDialog)
            SendMessage(hMainDialog,
                WM_AG_CONFIG_UPDATE_SERVER_LIST,
                0,
                0);

    }

    return result;
}

/* ----------------------------------------------------------------------------
*/
static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    confirmStruct * pInfo = (confirmStruct *)lParam;
    SetWindowLong(hwnd, GWL_USERDATA, lParam);
    SetDlgItemText(hwnd, IDC_CONFIRM_CAPTION, pInfo->confirmcaption);
    SetDlgItemText(hwnd, IDC_CONFIRM_TEXT, pInfo->confirmmessage);
    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    confirmStruct * pInfo = (confirmStruct *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case BN_CLICKED:
            switch (id) {
                case IDC_TEST:
                    AGConnectionTesterUIDo(hwnd, pInfo->sc);
                    SetDlgItemText(hwnd, IDC_SKIP, "&Continue");
                    //fallthrough
                case IDC_SKIP:
                    EndDialog(hwnd, id);
                    return;
                default:
                    break;
            }
            break;
        default:
            break;

    }
}

/* ----------------------------------------------------------------------------
*/
static BOOL CALLBACK dialogProc(HWND hwnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
    }

    return 0;   /* except for WM_INITDIALOG, returning zero means
                 we didn't process the message. */
}

/* ----------------------------------------------------------------------------
*/
static AGBool tryToHandleXMLFileLocally(LPSTR name)
{
    AGServerConfig * serverConfig, * testsc = NULL;
    char message[MAX_PATH];
    char caption[MAX_PATH];
    char * confirmcaption = NULL, * confirmmessage = NULL;
    AGBool added = FALSE;

    serverConfig = malloc(sizeof(AGServerConfig));

    if (NULL != serverConfig) {

        bzero(serverConfig, sizeof(AGServerConfig));

        if (0 != readConfigFromFile(name,
            serverConfig,
            &confirmcaption,
            &confirmmessage)) {

            if (NULL != confirmcaption)
                free(confirmcaption);

            if (NULL != confirmmessage)
                free(confirmmessage);

            AGServerConfigFree(serverConfig);

            return FALSE;

        } // if 0 != readConfigFromFile

        if (AGServerConfigIsValid(serverConfig)) {

            char tempstring[MAX_PATH];
            AGBool addAnything = FALSE;
            AGBool configureAll = FALSE;

            if (!AGConfigUtilWarnUser(hMainDialog, serverConfig)) {

                AGServerConfigFree(serverConfig);
                return TRUE;

            } // if AGConfigUtilWarnUser(hMainDialog, serverConfig)

            addAnything = AGUserChooserDo(NULL,
                &configureAll);

            if (!addAnything) {

                if (NULL != confirmcaption)
                    free(confirmcaption);

                if (NULL != confirmmessage)
                    free(confirmmessage);

                AGServerConfigFree(serverConfig);

                return TRUE;

            } // if (!addAnything)

            /* One copy should stay around for pinging later. */
            testsc = AGServerConfigDup(serverConfig);

            if (configureAll) {

                LoadString(g_hInstance,
                    IDS_CONFIRM_CONFIGURE_ALL_MESSAGE,
                    message,
                    MAX_PATH);

                LoadString(g_hInstance,
                    IDS_CONFIRM_CONFIGURE_ALL_CAPTION,
                    caption,
                    MAX_PATH);

                if (IDOK == MessageBox(hMainDialog,
                    message,
                    caption,
                    MB_OKCANCEL | MB_ICONQUESTION)) {

                    int i, n;
                    char * filename;
                    AGArray * array = AGDeviceUserDropDownBuild(NULL, NULL);

                    if (NULL != array) {

                        filename = (char*)AGSyncCommonGetStringConstant(
                            agPreferencesFilename, FALSE);

                        n = AGArrayCount(array);

                        for (i = 0; i < n; ++i) {

                            AGDeviceEntry * dle = NULL;

                            dle = (AGDeviceEntry *)AGArrayElementAt(
                                array,
                                i);

                            if (dle->prefsPath != NULL) {

                                char fullname[MAX_PATH];

                                PathCombine(fullname,
                                    dle->prefsPath,
                                    filename);

                                addServerToUserConfigFile(
                                    AGServerConfigDup(serverConfig),
                                    fullname,
                                    FALSE);

                            } // if (dle->prefsPath != NULL)

                        } // for (i = 0; i < n; ++i) {
                    
                        free(filename);
                        
                        AGDeviceUserDropDownReleaseDeviceList(array);

                    } // if (NULL != array) {

                } // if (IDOK == MessageBox(hMainDialog,
                else {
                    AGServerConfigFree(serverConfig);
                    return TRUE;
                }

                AGServerConfigFree(serverConfig);

            } // if (configureAll) {
            else {

                AGConfigUtilGetCurrentUserConfigFilename(tempstring, NULL);

                added = addServerToUserConfigFile(serverConfig,
                    tempstring,
                    TRUE);

            } // else

            if (NULL != confirmcaption &&
                NULL != confirmmessage && added) {

                confirmStruct cs;

                cs.confirmmessage = confirmmessage;
                cs.confirmcaption = confirmcaption;
                cs.sc = testsc;
                DialogBoxParam(g_hInstance,
                    MAKEINTRESOURCE(IDD_MAL_CONFIRMATION),
                    hMainDialog,
                    dialogProc,
                    (LONG)&cs);

            } // if (NULL != confirmcaption &&

            if (NULL != testsc)
                AGServerConfigFree(testsc);

            if (NULL != confirmcaption)
                free(confirmcaption);

            if (NULL != confirmmessage)
                free(confirmmessage);

            return TRUE;

        } // if (AGServerConfigIsValid(serverConfig)) {
        else {

            LoadString(g_hInstance,
                IDS_BAD_XML_MESSAGE,
                message,
                MAX_PATH);

            LoadString(g_hInstance,
                IDS_BAD_XML_CAPTION,
                caption,
                MAX_PATH);

            MessageBox(hMainDialog,
                message,
                caption,
                MB_OK | MB_ICONEXCLAMATION);

            AGServerConfigFree(serverConfig);

        } // else

    } // if (NULL != serverConfig) {

    return FALSE;
}

/* ----------------------------------------------------------------------------
*/
AGBool AGConfigHandleXMLFile(HWND hwnd,
                             LPSTR name)
{
    if (tryToHandleXMLFileLocally(name)) {
        return TRUE;
    } else
        return AGXMLSubmitterHandleFileForCurrentDevice(hwnd, name, FALSE);
}