/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#ifndef __AGCONFIGUTIL_H__
#define __AGCONFIGUTIL_H__

#include <windows.h>
#include <commctrl.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#include <AGTypes.h>
#include <AGServerConfig.h>

#define KEEPPASSWORD "oiY{Q)!$%*#(_0q~:{E8"

#define tipdim(x) (sizeof(x) / sizeof(x[0]))

typedef struct {
    int controlID;
    int stringID;
} AGToolTip;

char * AGConfigWindowTextDup(HWND hwnd);
int AGConfigAddToolTip(HWND toolTip, int itemID, int stringID);
void AGConfigUtilCheckWizButtons(uint32 nHwnd, HWND * hwnd, int32 exclude);
void AGConfigUtilCheckDialogButtons(uint32 nHwnd, HWND * hwnd);
AGBool AGConfigUtilIsServerInList(char * userConfigPath,
                                  char * serverName,
                                  int16 serverPort);
int AGConfigUtilDisplayDuplicateErrorMessage(HWND hwnd, AGBool disallow);
void AGConfigUtilAddServerToUserConfigFile(AGServerConfig * sc,
                                           char * filename);
void AGConfigUtilGetCurrentUserConfigFilename(char * userConfig,
                                              char * syncUserConfig);
void AGConfigUtilRemoveServerFromUserConfigFile(char * serverName,
                                                int16 serverPort,
                                                char * filename);
HWND AGConfigUtilAddToolTips(HWND control, const AGToolTip * tips, int n);
AGBool AGConfigUtilWarnUser(HWND parent, AGServerConfig * serverConfig);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // #ifndef __AGCONFIGUTIL_H__