/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#include <AGConfigProxyDialog.h>
#include <AGConfigDomainExclusionDialog.h>
#include <AGLocationConfig.h>
#include <AGConfigUtil.h>
#include <windowsx.h>

typedef struct pdWindowInfo {

    HWND hwnd;
    AGLocationConfig * locationConfig;
    HWND toolTipControl;

} pdWindowInfo;

/* ----------------------------------------------------------------------------
*/
static void checkButtons(HWND hwnd)
{
    HWND hwnds[5];
    int next = 0;

    if (IsDlgButtonChecked(hwnd, IDC_USE_HTTP)) {

        hwnds[next++] = GetDlgItem(hwnd, IDC_PROXY_NAME);
        hwnds[next++] = GetDlgItem(hwnd, IDC_PROXY_PORT);

        if (IsDlgButtonChecked(hwnd, IDC_USE_AUTHENTICATION))
            hwnds[next++] = GetDlgItem(hwnd, IDC_PROXY_USERNAME);
    }
    if (IsDlgButtonChecked(hwnd, IDC_USE_SOCKS)) {
        hwnds[next++] = GetDlgItem(hwnd, IDC_SOCKS_PROXY_NAME);
        hwnds[next++] = GetDlgItem(hwnd, IDC_SOCKS_PROXY_PORT);
    }

    if (next > 0)
        AGConfigUtilCheckDialogButtons(next, hwnds);
    else
        AGConfigUtilCheckDialogButtons(0, &hwnd);
}

const AGToolTip tips [] = {

    IDC_USE_HTTP, IDS_TIP_USE_HTTP,
    IDC_PROXY_NAME, IDS_TIP_PROXY_NAME,
    IDC_PROXY_PORT, IDS_TIP_PROXY_PORT,
    IDC_USE_AUTHENTICATION, IDS_TIP_USE_AUTHENTICATION,
    IDC_PROXY_USERNAME, IDS_TIP_PROXY_USERNAME,
    IDC_PROXY_PASSWORD, IDS_TIP_PROXY_PASSWORD,
    IDC_USE_SOCKS, IDS_TIP_USE_SOCKS,
    IDC_SOCKS_PROXY_NAME, IDS_TIP_SOCKS_PROXY_NAME,
    IDC_SOCKS_PROXY_PORT, IDS_TIP_SOCKS_PROXY_PORT

};

/* ----------------------------------------------------------------------------
*/
static void updateEnabledStates(HWND hwnd)
{
    BOOL state;
    
    state = IsDlgButtonChecked(hwnd, IDC_USE_HTTP);
    EnableWindow(GetDlgItem(hwnd, IDC_PROXY_NAME), state);
    EnableWindow(GetDlgItem(hwnd, IDC_PROXY_PORT), state);
    EnableWindow(GetDlgItem(hwnd, IDC_USE_AUTHENTICATION), state);
    state = state && IsDlgButtonChecked(hwnd, IDC_USE_AUTHENTICATION);
    EnableWindow(GetDlgItem(hwnd, IDC_PROXY_USERNAME), state);
    EnableWindow(GetDlgItem(hwnd, IDC_PROXY_PASSWORD), state);
    state = IsDlgButtonChecked(hwnd, IDC_USE_SOCKS);
    EnableWindow(GetDlgItem(hwnd, IDC_SOCKS_PROXY_NAME), state);
    EnableWindow(GetDlgItem(hwnd, IDC_SOCKS_PROXY_PORT), state);
//    EnableWindow(GetDlgItem(hwnd, IDC_SOCKS_PROXY_ID), state);

    checkButtons(hwnd);
}

/* ----------------------------------------------------------------------------
*/
static void setupDialogFields(HWND hwnd, AGLocationConfig * loc)
{
    char buf[10];

    // Set up HTTP proxy information.
    CheckDlgButton(hwnd, IDC_USE_HTTP, loc->HTTPUseProxy
        ? BST_CHECKED : BST_UNCHECKED);
    SetWindowText(GetDlgItem(hwnd, IDC_PROXY_NAME), loc->HTTPName);
    if (loc->HTTPPort > 0) {
        _itoa(loc->HTTPPort, buf, 10);
        SetWindowText(GetDlgItem(hwnd, IDC_PROXY_PORT), buf);
    }
    else
        SetWindowText(GetDlgItem(hwnd, IDC_PROXY_PORT), "");

    // Set up HTTP proxy authentication information.
    CheckDlgButton(hwnd, IDC_USE_AUTHENTICATION,
        loc->HTTPUseAuthentication ? BST_CHECKED : BST_UNCHECKED);
    SetWindowText(GetDlgItem(hwnd, IDC_PROXY_USERNAME), loc->HTTPUsername);
    SetWindowText(GetDlgItem(hwnd, IDC_PROXY_PASSWORD), loc->HTTPPassword);

    // Set up SOCKS proxy information.
    CheckDlgButton(hwnd, IDC_USE_SOCKS, loc->SOCKSUseProxy
        ? BST_CHECKED : BST_UNCHECKED);
    SetWindowText(GetDlgItem(hwnd, IDC_SOCKS_PROXY_NAME), loc->SOCKSName);
    if (loc->SOCKSPort > 0) {
        _itoa(loc->SOCKSPort, buf, 10);
        SetWindowText(GetDlgItem(hwnd, IDC_SOCKS_PROXY_PORT), buf);
    }
    else
        SetWindowText(GetDlgItem(hwnd, IDC_SOCKS_PROXY_PORT), "");
    updateEnabledStates(hwnd);
}

/* ----------------------------------------------------------------------------
*/
static void reapDialogFields(HWND hwnd, AGLocationConfig * loc)
{
    char buf[10];

    // Get HTTP proxy information.
    loc->HTTPUseProxy = IsDlgButtonChecked(hwnd, IDC_USE_HTTP)
        ? BST_CHECKED : BST_UNCHECKED;
    if (NULL != loc->HTTPName)
        free(loc->HTTPName);
    loc->HTTPName = AGConfigWindowTextDup(GetDlgItem(hwnd, IDC_PROXY_NAME));
    GetWindowText(GetDlgItem(hwnd, IDC_PROXY_PORT), buf, 10);
    loc->HTTPPort = atoi(buf);

    // Get HTTP proxy authentication information.
    loc->HTTPUseAuthentication =
        IsDlgButtonChecked(hwnd, IDC_USE_AUTHENTICATION)
        ? BST_CHECKED : BST_UNCHECKED;
    if (NULL != loc->HTTPUsername)
        free(loc->HTTPUsername);
    loc->HTTPUsername =
        AGConfigWindowTextDup(GetDlgItem(hwnd, IDC_PROXY_USERNAME));
    if (NULL != loc->HTTPPassword)
        free(loc->HTTPPassword);
    loc->HTTPPassword = 
        AGConfigWindowTextDup(GetDlgItem(hwnd, IDC_PROXY_PASSWORD));

    // Get SOCKS proxy information.
    loc->SOCKSUseProxy = IsDlgButtonChecked(hwnd, IDC_USE_SOCKS)
        ? BST_CHECKED : BST_UNCHECKED;
    if (NULL != loc->SOCKSName)
        free(loc->SOCKSName);
    loc->SOCKSName =
        AGConfigWindowTextDup(GetDlgItem(hwnd, IDC_SOCKS_PROXY_NAME));
    GetWindowText(GetDlgItem(hwnd, IDC_SOCKS_PROXY_PORT), buf, 10);
    loc->SOCKSPort = atoi(buf);

    updateEnabledStates(hwnd);
}

/* ----------------------------------------------------------------------------
*/
static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    SetWindowLong(hwnd, GWL_USERDATA, lParam);
    pdWindowInfo * pInfo = (pdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    pInfo->toolTipControl = AGConfigUtilAddToolTips(hwnd,
        &tips[0],
        tipdim(tips));
    setupDialogFields(hwnd, pInfo->locationConfig);

    checkButtons(hwnd);

    return FORWARD_WM_INITDIALOG(hwnd, hwndFocus,
        lParam, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------
*/
static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    pdWindowInfo * pInfo = (pdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case EN_CHANGE:
            checkButtons(hwnd);
            return;
        case BN_CLICKED:
            switch (id) {
                case IDC_WIZARD:
                    EndDialog(hwnd, IDC_WIZARD);
                    return;
/*                case ID_EXCLUDE_DOMAINS:
                    AGConfigDomainExclusionDialogDo(hwnd, 
                        pInfo->locationConfig);
                    return;*/
                case IDC_USE_HTTP:
                case IDC_USE_SOCKS:
                case IDC_USE_AUTHENTICATION:
                    updateEnabledStates(hwnd);
                    break;
                case IDOK:
                    reapDialogFields(hwnd, pInfo->locationConfig);
                    pInfo->locationConfig->source = AG_PROXY_USER_SUPPLIED;
                    EndDialog(hwnd, IDOK);
                    break;
                default:
                    break;
            }
            break;
        default:
            break;

    }
    FORWARD_WM_COMMAND(hwnd, id, hwndCtl,
        codeNotify, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------
*/
static BOOL CALLBACK dialogProc(HWND hwnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
    }

    return 0;   // except for WM_INITDIALOG, returning zero means
                // we didn't process the message.
}

/* ----------------------------------------------------------------------------
*/
int AGConfigProxyDialogDo(const HWND parentHwnd,
                          AGLocationConfig * locationConfig)
{
    pdWindowInfo info;
    info.hwnd = parentHwnd;
    info.locationConfig = locationConfig;
    info.toolTipControl = NULL;
    int result = 0;

    result = DialogBoxParam(g_hInstance, MAKEINTRESOURCE(IDD_PROXY),
        parentHwnd, dialogProc, (LPARAM)&info);

    if (NULL != info.toolTipControl)
        DestroyWindow(info.toolTipControl);

    switch (result) {
        case IDOK:
            result = 1;
            break;
        case IDCANCEL:
            result = 0;
            break;
        case IDC_WIZARD:
            result = -1;
            break;
    }

    return result;
}
