/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGConfigDomainExclusionDialog.h>
#include <AGConfigUtil.h>
#include <windowsx.h>

typedef struct dedWindowInfo {

    HWND hwnd;
    AGLocationConfig * locationConfig;
    HWND toolTipControl;

} dedWindowInfo;

/* ----------------------------------------------------------------------------
*/
static void addToolTips(HWND hwnd, dedWindowInfo * pInfo)
{
    pInfo->toolTipControl = CreateWindowEx(0,
        (LPSTR)TOOLTIPS_CLASS,
        (LPSTR)NULL,
        WS_POPUP | TTS_ALWAYSTIP,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT, 
        hwnd,
        (HMENU)NULL,
        g_hInstance,
        NULL);

    AGConfigAddToolTip(pInfo->toolTipControl,
        IDC_PROXY_WIZ_EXCLUDE_DOMAINS_EDIT,
        IDS_TIP_PROXY_WIZ_EXCLUDE_DOMAINS_EDIT);

}

/* ----------------------------------------------------------------------------
*/
void AGConfigDomainExclusionSetup(HWND hwnd, AGArray * array)
{

    int i, n;
    char * buf;
    AGBool appendSeparator = FALSE;

    SetWindowText(hwnd, "");

    n = AGArrayCount(array);
    if (n < 1)
        return;

    buf = (char*)malloc(MAX_PATH * n);
    if (NULL == buf)
        return;

    buf[0] = '\0';
    for (i = 0; i < n; ++i) {

        char * name;

        name = (char*)AGArrayElementAt(array,
            i);

        if (NULL == name)
            continue;

        if (appendSeparator)
            strcat(buf, "; ");
        else
            appendSeparator = TRUE;

        strcat(buf, name);

    }

    SetWindowText(hwnd, buf);

    free(buf);

}

/* ----------------------------------------------------------------------------
*/
void AGConfigDomainExclusionFreeArray(AGArray * array)
{
    uint32 i, n;

    n = AGArrayCount(array);

    for (i = 0; i < n; ++i) {

        char * s;

        s = (char *)AGArrayElementAt(array, i);

        if (NULL != s)
            free(s);
    }

    if (n > 0)
        AGArrayRemoveAll(array);

    if (NULL != array)
        AGArrayFree(array);
}

/* ----------------------------------------------------------------------------
*/
AGArray * AGConfigDomainExclusionFill(char * list)
{

    AGArray * result;
    char * delim = "\n ;,\t";
    char * token;

    result = AGArrayNew(AGUnownedPointerElements, 0);

    if (NULL == result)
        return NULL;

    token = strtok(list, delim);

    while (NULL != token) {

        AGArrayAppend(result, strdup(token));

        token = strtok(NULL, delim);

    }

    return result;

}

/* ----------------------------------------------------------------------------
*/
static void reapDialogFields(HWND hwnd, dedWindowInfo * info)
{
    char buf[8192];
    AGBool appendSeparator = FALSE;

    GetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_EXCLUDE_DOMAINS_EDIT),
        buf,
        8192);

    AGConfigDomainExclusionFreeArray(info->locationConfig->exclusionServers);

    info->locationConfig->exclusionServers = AGConfigDomainExclusionFill(buf);

}

/* ----------------------------------------------------------------------------
*/
static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    SetWindowLong(hwnd, GWL_USERDATA, lParam);
    dedWindowInfo * info = (dedWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    addToolTips(hwnd, info);

    AGConfigDomainExclusionSetup(
        GetDlgItem(hwnd, IDC_PROXY_WIZ_EXCLUDE_DOMAINS_EDIT),
        info->locationConfig->exclusionServers);

    return FORWARD_WM_INITDIALOG(hwnd, hwndFocus,
        lParam, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------
*/
static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    dedWindowInfo * info = (dedWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case BN_CLICKED:
            switch (id) {
                case IDOK:
                    reapDialogFields(hwnd, info);
                    EndDialog(hwnd, IDOK);
                    break;
                case IDCANCEL:
                    EndDialog(hwnd, IDCANCEL);
                    break;
                default:
                    break;
            }
            break;
        default:
            break;

    }
    FORWARD_WM_COMMAND(hwnd, id, hwndCtl,
        codeNotify, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------
*/
static BOOL CALLBACK dialogProc(HWND hwnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
    }

    return 0;   /* except for WM_INITDIALOG, returning zero means
                we didn't process the message. */
}

/* ----------------------------------------------------------------------------
*/
int AGConfigDomainExclusionDialogDo(const HWND parentHwnd,
                                    AGLocationConfig * locationConfig)
{
    dedWindowInfo info;
    info.hwnd = parentHwnd;
    info.locationConfig = locationConfig;
    info.toolTipControl = NULL;
    int result = 0;    

    result = DialogBoxParam(g_hInstance,
        MAKEINTRESOURCE(IDD_EXCLUDE),
        parentHwnd,
        dialogProc,
        (LPARAM)&info);

    if (NULL != info.toolTipControl)
        DestroyWindow(info.toolTipControl);

    return result;
}
