/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGConfigUtil.h>
#include <AGDigest.h>
#include <AGMD5.h>
#include <AGConfigAddServerDialog.h>
#include <AGUtil.h>
#include <AGConfigDialogBase.h>
#include <windowsx.h>

typedef struct asdWindowInfo {

    HWND hwnd;
    AGServerConfig * serverConfig;
    HWND toolTipControl;
    char * userConfigPath;

} asdWindowInfo;

const AGToolTip tips [] = {

    IDC_ADD_SERVER_NAME, IDS_TIP_ADD_SERVER_NAME,
    IDC_ADD_SERVER_URL, IDS_TIP_ADD_SERVER_URL,
    IDC_ADD_SERVER_PORT, IDS_TIP_ADD_SERVER_PORT,
    IDC_ADD_SERVER_USERNAME, IDS_TIP_ADD_SERVER_USERNAME,
    IDC_ADD_SERVER_PASSWORD, IDS_TIP_ADD_SERVER_PASSWORD,
    IDC_CONNECT_SECURELY, IDS_TIP_CONNECT_SECURELY

};

/* ----------------------------------------------------------------------------
*/
static void checkButtons(HWND hwnd)
{
    HWND hwnds[4];

    hwnds[0] = GetDlgItem(hwnd, IDC_ADD_SERVER_NAME);
    hwnds[1] = GetDlgItem(hwnd, IDC_ADD_SERVER_URL);
    hwnds[2] = GetDlgItem(hwnd, IDC_ADD_SERVER_PORT);
    hwnds[3] = GetDlgItem(hwnd, IDC_ADD_SERVER_USERNAME);

    AGConfigUtilCheckDialogButtons(4, hwnds);
}

/* ----------------------------------------------------------------------------
*/
static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    char buf[32];
    SetWindowLong(hwnd, GWL_USERDATA, lParam);
    asdWindowInfo * pInfo = (asdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);
    pInfo->hwnd = hwnd;

    pInfo->toolTipControl = AGConfigUtilAddToolTips(hwnd,
        &tips[0],
        tipdim(tips));

    SetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_NAME),
        pInfo->serverConfig->friendlyName);

    SetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_URL),
        pInfo->serverConfig->serverName);

    if (pInfo->serverConfig->serverPort > 0) {
        itoa(pInfo->serverConfig->serverPort, buf, 10);
        SetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_PORT), buf);
    }
    else
        SetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_PORT), "");

    SetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_USERNAME),
        pInfo->serverConfig->userName);

    if (pInfo->serverConfig->hashPassword) {

        if (AGDigestNull(pInfo->serverConfig->password))
            SetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_PASSWORD), "");
        else
            SetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_PASSWORD),
                KEEPPASSWORD);

    } else {

        if (NULL == pInfo->serverConfig->cleartextPassword)
            SetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_PASSWORD), "");
        else
            SetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_PASSWORD),
                pInfo->serverConfig->cleartextPassword);

    }

    CheckDlgButton(hwnd,
        IDC_CONNECT_SECURELY,
        pInfo->serverConfig->connectSecurely);

    EnableWindow(GetDlgItem(hwnd, IDC_CONNECT_SECURELY),
        pInfo->serverConfig->allowSecureConnection);

    checkButtons(hwnd);

    return FORWARD_WM_INITDIALOG(hwnd, hwndFocus,
        lParam, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------
*/
static void doOK(HWND hwnd, asdWindowInfo * pInfo)
{
    char buf[32];
    char plaintext[MAX_PATH];

    if (NULL != pInfo->serverConfig->friendlyName)
        free(pInfo->serverConfig->friendlyName);
    pInfo->serverConfig->friendlyName =
        AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_ADD_SERVER_NAME));

    if (NULL != pInfo->serverConfig->serverName)
        free(pInfo->serverConfig->serverName);
    pInfo->serverConfig->serverName =
        AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_ADD_SERVER_URL));

    GetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_PORT),
        buf, 32);
    pInfo->serverConfig->serverPort = atoi(buf);

    if (NULL != pInfo->serverConfig->userName)
        free(pInfo->serverConfig->userName);
    pInfo->serverConfig->userName =
        AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_ADD_SERVER_USERNAME));

    GetWindowText(GetDlgItem(hwnd, IDC_ADD_SERVER_PASSWORD),
        plaintext, MAX_PATH);

    if (pInfo->serverConfig->hashPassword) {

        if (strcmp(KEEPPASSWORD, plaintext)) {

            if (strlen(plaintext) > 0)
                AGMd5((uint8*)plaintext, strlen(plaintext),
                    pInfo->serverConfig->password);
            else
                AGDigestSetToNull(pInfo->serverConfig->password);

        }

    } else {

        if (NULL != pInfo->serverConfig->cleartextPassword)
            free(pInfo->serverConfig->cleartextPassword);

        if (strlen(plaintext) > 0) {

            pInfo->serverConfig->cleartextPassword =
                strdup(plaintext);

        } else {

            pInfo->serverConfig->cleartextPassword = NULL;

        }

    }

    pInfo->serverConfig->connectSecurely =
        IsDlgButtonChecked(hwnd, IDC_CONNECT_SECURELY);

}

/* ----------------------------------------------------------------------------
*/
static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    asdWindowInfo * pInfo = (asdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case EN_CHANGE:
            checkButtons(hwnd);
            return;
        case BN_CLICKED:
            switch (id) {
                case IDOK: {
                    doOK(hwnd, pInfo);
                    if (AGConfigUtilIsServerInList(pInfo->userConfigPath,
                        pInfo->serverConfig->serverName,
                        pInfo->serverConfig->serverPort))
                        AGConfigUtilDisplayDuplicateErrorMessage(hwnd, TRUE);
                    else {
                        EndDialog(hwnd, IDOK);
                    }
                    return;
                }
                case IDCANCEL: {
                    EndDialog(hwnd, IDCANCEL);
                    return;
                }
                case IDC_WIZARD: {
                    EndDialog(hwnd, IDC_WIZARD);
                    return;
                }
                default:
                    break;
            }
            break;
        default:
            break;

    }
    FORWARD_WM_COMMAND(hwnd, id, hwndCtl, codeNotify, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------
*/
static BOOL CALLBACK dialogProc(HWND hwnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
    }

    return 0;   /* except for WM_INITDIALOG, returning zero means
                 we didn't process the message. */
}

/* ----------------------------------------------------------------------------
*/
int AGConfigAddServerDialogDo(const HWND parentHwnd,
                              AGServerConfig * serverConfig,
                              char * userConfigPath)
{
    asdWindowInfo info;
    info.toolTipControl = NULL;
    int result = 0;
    
    info.serverConfig = (AGServerConfig *)malloc(sizeof(AGServerConfig));
    info.userConfigPath = userConfigPath;

    if (NULL != info.serverConfig) {

        bzero(info.serverConfig, sizeof(AGServerConfig));

        info.serverConfig->serverPort = AG_DEFAULT_PORT;

        /* pending(miket):  Until we implement cleartext handling,   
        default to hashing all the time. */   
        info.serverConfig->hashPassword = TRUE; 

        result = DialogBoxParam(g_hInstance,
            MAKEINTRESOURCE(IDD_SERVER),
            parentHwnd,
            dialogProc,
            (LPARAM)&info);

        if (IDOK == result)
            AGServerConfigCopy(serverConfig, info.serverConfig);

        AGServerConfigFree(info.serverConfig);
    }

    if (NULL != info.toolTipControl)
        DestroyWindow(info.toolTipControl);

    switch (result) {
        case IDOK:
            result = 1;
            break;
        case IDCANCEL:
            result = 0;
            break;
        case IDC_WIZARD:
            result = -1;
            break;
    }

    return result;

}