/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGMLUtil.h>
#include <windowsx.h>

void AGMLHandleDropDown(HWND hwndComboBox)
{
    RECT r;
    HDC dc;
    HFONT font;
    TEXTMETRIC tm;
    int height;

    if (!IsWindow(hwndComboBox))
        return;

    dc = GetDC(hwndComboBox);
    font = GetWindowFont(hwndComboBox);
    if (NULL != font)
        SelectObject(dc, font);
    GetTextMetrics(dc, &tm);
    ReleaseDC(hwndComboBox, dc);
    height = max(ComboBox_GetCount(hwndComboBox) + 2, 4)
        * (tm.tmHeight + tm.tmExternalLeading);

    ComboBox_GetDroppedControlRect(hwndComboBox, &r);
    ScreenToClient(GetParent(hwndComboBox), (LPPOINT)&r.left);
    ScreenToClient(GetParent(hwndComboBox), (LPPOINT)&r.right);

    MoveWindow(hwndComboBox,
        r.left,
        r.top,
        r.right - r.left,
        height,
        TRUE);
}