/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGMLApp.h>
#include <AGMLMainWindow.h>
#include <AGMLMainDialog.h>
#include <windowsx.h>
#include "AGMLResources.h"

#define kMLMainWindowClass (TEXT("Mobile Link Main Window Class"))
#define kMLMainWindowTitle (TEXT("Mobile Link"))

typedef struct tagMLMainWindow {
    HINSTANCE hInst;
} MLMainWindow, * pMLMainWindow;

typedef struct tagMLControl {
    LPTSTR title;
    int id;
    int cx, cy;
} MLControl;

static pMLMainWindow getLocalStorage(HWND hwnd)
{
    return (pMLMainWindow)GetWindowLong(hwnd, GWL_USERDATA);
}

static BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct)
{
    pMLMainWindow pInfo;
    
    // Allocate storage for this window.  Return if it fails.
    pInfo = (pMLMainWindow)malloc(sizeof(MLMainWindow));
    if (NULL == pInfo)
        return FALSE;

    // Out of caution, zero out structure.
    memset(pInfo, 0, sizeof(MLMainWindow));

    // Remember address to this structure.
    SetWindowLong(hwnd, GWL_USERDATA, (LONG)pInfo);

    // Retrieve instance handle that was passed in when window
    // was created.
    pInfo->hInst = (HINSTANCE)lpCreateStruct->lpCreateParams;

    /* TRUE == success.  This is the opposite of the correct return code
    for a successful WM_CREATE handling, but the windowsx message cracker
    flips the value. */

    return TRUE;
}

static void onDestroy(HWND hwnd)
{
    pMLMainWindow pInfo;
    
    if (IsWindow(g_hwndMainDialog))
        DestroyWindow(g_hwndMainDialog);

    pInfo = getLocalStorage(hwnd);

    if (NULL != pInfo)
        free(pInfo);

    // Tell ourselves to quit.
    PostQuitMessage(0);
}

static LRESULT CALLBACK wndProc(HWND hwnd,
                                UINT message,
                                WPARAM wParam,
                                LPARAM lParam)
{
    pMLMainWindow pInfo;
    
    pInfo = getLocalStorage(hwnd);

    switch (message) {
        HANDLE_MSG(hwnd, WM_CREATE, onCreate);
        HANDLE_MSG(hwnd, WM_DESTROY, onDestroy);
        case AGML_MAIN_DIALOG:
            AGMLMainDialogDo(hwnd, pInfo->hInst);
            return 0;
        case AGML_SYNCHRONIZE:
        case AGML_SERVER_OPTIONS:
            if (IsWindow(g_hwndMainDialog)) {
                return PostMessage(g_hwndMainDialog,
                    message,
                    wParam,
                    lParam);
            }
            else
                return 0;
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
}

ATOM AGMLMainWindowRegisterAppClass(HINSTANCE hInstance)
{
    WNDCLASS wc;

    wc.style         = 0;
    wc.lpfnWndProc   = wndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = NULL;
    wc.hCursor       = NULL;
    wc.hbrBackground = NULL;
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = kMLMainWindowClass;

    return RegisterClass(&wc);

}

HWND AGMLMainWindowCreate(HINSTANCE hInstance, ATOM appClassAtom)
{
    return CreateWindowEx(0,
        (LPCTSTR)MAKELONG(appClassAtom, 0),
        kMLMainWindowTitle,
        WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        1,
        1,
        NULL,
        NULL,
        hInstance,
        hInstance);
}

LPTSTR AGMLMainWindowClassName(void)
{
    return kMLMainWindowClass;
}