/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGMLChangePasswordDialog.h>
#include <AGMLUtilWinCE.h>
#include "AGMLResources.h"
#include <AGMD5.h>
#include <AGDigest.h>
#include <windowsx.h>

HINSTANCE ghInstance;

static void messageBox(HWND hwnd,
                       int messageID,
                       int captionID,
                       UINT flags)
{
    WCHAR message[MAX_PATH];
    WCHAR caption[MAX_PATH];

    LoadString(ghInstance, messageID, message, MAX_PATH);
    LoadString(ghInstance, captionID, caption, MAX_PATH);

    MessageBox(hwnd, message, caption, flags);

}

static void checkForValidChange(HWND hwnd)
{

    WCHAR wcsold[MAX_PATH];
    WCHAR wcsnew[MAX_PATH];
    WCHAR wcsagain[MAX_PATH];

    char mbsold[MAX_PATH];
    char mbsnew[MAX_PATH];
    char mbsagain[MAX_PATH];

    uint8 hashold[16];
    uint8 hashnew[16];
    uint8 hashagain[16];

    AGServerConfig * serverConfig;

    serverConfig = (AGServerConfig *)GetWindowLong(hwnd, GWL_USERDATA);

    GetDlgItemText(hwnd, IDC_OLD_PASSWORD, wcsold, MAX_PATH);
    GetDlgItemText(hwnd, IDC_NEW_PASSWORD, wcsnew, MAX_PATH);
    GetDlgItemText(hwnd, IDC_CONFIRM_PASSWORD, wcsagain, MAX_PATH);

    wcstombs(mbsold, wcsold, -1);
    wcstombs(mbsnew, wcsnew, -1);
    wcstombs(mbsagain, wcsagain, -1);

    if (NULL != serverConfig) {

        if (serverConfig->hashPassword) {

            AGMd5(mbsold, strlen(mbsold), hashold);
            AGMd5(mbsnew, strlen(mbsnew), hashnew);
            AGMd5(mbsagain, strlen(mbsagain), hashagain);

            if (!AGDigestNull(serverConfig->password) 
                && !AGDigestCompare(hashold, serverConfig->password)) {

                messageBox(hwnd,
                    IDS_OLD_WRONG,
                    IDS_CHANGE_PASSWORD_FAILED_CAPTION,
                    MB_OK | MB_ICONEXCLAMATION);

                return;

            }

            if (!AGDigestCompare(hashnew, hashagain)) {

                messageBox(hwnd,
                    IDS_NOT_SAME,
                    IDS_CHANGE_PASSWORD_FAILED_CAPTION,
                    MB_OK | MB_ICONEXCLAMATION);

                return;

            }

            memcpy(serverConfig->password, hashnew, 16);

                messageBox(hwnd,
                    IDS_CHANGE_PASSWORD_SUCCESS,
                    IDS_CHANGE_PASSWORD_SUCCESS_CAPTION,
                    MB_OK | MB_ICONEXCLAMATION);

        }
        else {

            messageBox(hwnd,
                IDS_NO_CLEARTEXT,
                IDS_CHANGE_PASSWORD_FAILED_CAPTION,
                MB_OK | MB_ICONEXCLAMATION);

        }

    }

}

static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    switch (codeNotify) {
        case EN_SETFOCUS:
            ShowSIP(hwnd);
            break;
        case EN_KILLFOCUS:
            ModifySIP(hwnd, 0, SIPF_DISABLECOMPLETION);
            break;
        case BN_CLICKED:
            switch (id) {
                case IDOK:
                    checkForValidChange(hwnd);
                case IDCANCEL:
                    HideSIP(hwnd);
                    EndDialog(hwnd, id);
                    break;
            }
            break;
        default:
            break;
    }
}

static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    TCHAR buf[MAX_PATH];
    TCHAR proto[MAX_PATH];
    AGServerConfig * serverConfig;

    SetWindowLong(hwnd, GWL_USERDATA, lParam);

    serverConfig = (AGServerConfig *)lParam;

    GetDlgItemText(hwnd, IDC_PASSWORD_TEXT, proto, MAX_PATH);

    if (NULL != serverConfig && AGServerConfigIsValid(serverConfig)) {

        TCHAR friendly[MAX_PATH], server[MAX_PATH];

        mbstowcs(friendly, serverConfig->friendlyName, -1);
        mbstowcs(server, serverConfig->serverName, -1);

        wsprintf(buf,
            proto,
            friendly,
            server,
            serverConfig->serverPort);

    } else {

        wsprintf(buf,
            proto,
            TEXT("<unknown>"),
            TEXT("<unknown>"),
            80);

    }

    SetDlgItemText(hwnd, IDC_PASSWORD_TEXT, buf);

    return TRUE;

}

static BOOL CALLBACK dialogProc(HWND hwnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
    }
    return 0;
}

int AGMLChangePasswordDialogDo(HWND hwndParent,
                               HINSTANCE hInstance,
                               AGServerConfig * serverConfig)
{
    ghInstance = hInstance;

    return DialogBoxParam(hInstance,
        MAKEINTRESOURCE(AGDigestNull(serverConfig->password)
            ? IDD_NEW_PASSWORD
            : IDD_CHANGE_PASSWORD),
        hwndParent,
        dialogProc,
        (LONG)serverConfig);
}
