/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGMLApp.h>
#include <AGMLMainWindow.h>
#include <commctrl.h>

HANDLE hMutex = NULL;

static void checkCommandLine(LPTSTR cmd, HWND hwnd)
{
    if (cmd && *cmd) {

        if (!_tcscmp(cmd, TEXT("-sync"))) {

            PostMessage(hwnd, AGML_SYNCHRONIZE, 0, 0);

        } else if (!_tcscmp(cmd, TEXT("-options"))) {

            PostMessage(hwnd, AGML_SERVER_OPTIONS, 0, 0);
        }

    }
}

static BOOL CheckForPreviousInstance(LPTSTR cmd)
{
    /* Create a named mutex that will exist, system-wide, during the
    lifetime of this instance.  If it already existed, then this app 
    is already running and we should exit. */

    hMutex = CreateMutex(NULL, FALSE, TEXT("MAL Mutex"));

    if (NULL != hMutex && ERROR_ALREADY_EXISTS == GetLastError()) {

        HWND hwnd;
        
        CloseHandle(hMutex);

        hwnd = FindWindow(AGMLMainWindowClassName(), NULL);

        if (IsWindow(hwnd)) {

            SetForegroundWindow(hwnd);
            checkCommandLine(cmd, hwnd);

        }
        return TRUE;
    }

    return FALSE;
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR lpCmdLine,
                     int nCmdShow)
{
    int ret = 0;
    HACCEL haccel = NULL;
    MSG msg;
    ATOM appClassAtom;
    HWND hwndMain = NULL;

    /* Check to see if we're already running. */
    if (CheckForPreviousInstance(lpCmdLine))
        return ret;

    /* Be sure Windows common controls are available. */
    InitCommonControls();

    appClassAtom = AGMLMainWindowRegisterAppClass(hInstance);

    hwndMain = AGMLMainWindowCreate(hInstance, appClassAtom);

    if (IsWindow(hwndMain)) {

        ShowWindow(hwndMain, SW_HIDE);

        PostMessage(hwndMain, AGML_MAIN_DIALOG, 0, 0);

        checkCommandLine(lpCmdLine, hwndMain);

        /* Standard windows event loop. */
        while (GetMessage(&msg, NULL, 0, 0)) {
            if (!TranslateAccelerator(msg.hwnd, haccel, &msg)) {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
            }
        }

        /* If we got here, we got a WM_QUIT message and wParam contains
        the result code. */
        ret = msg.wParam;

        DestroyWindow(hwndMain);

    }

    if (hMutex)
        CloseHandle(hMutex);

    return ret;
}
