/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGMLUtilWinCE.h>

static void ScreenRectToClientRect(HWND hwnd, RECT * pButtonRect)
{
    POINT point;
    point.x = pButtonRect->left;
    point.y = pButtonRect->top;
    ScreenToClient(hwnd, &point);
    pButtonRect->left = point.x;
    pButtonRect->top = point.y;

    point.x = pButtonRect->right;
    point.y = pButtonRect->bottom;
    ScreenToClient(hwnd, &point);
    pButtonRect->right = point.x;
    pButtonRect->bottom = point.y;
}

#ifndef HPC

void ModifySIP(HWND hwnd, int flagsToSet, int flagsToClear)
{
    SIPINFO sipInfo;
    memset(&sipInfo, 0, sizeof(sipInfo));
    sipInfo.cbSize = sizeof(sipInfo);
    SHSipInfo(SPI_GETSIPINFO, 0, &sipInfo, 0);
    if(SHSipInfo(SPI_GETSIPINFO, 0, &sipInfo, 0))
    {
        sipInfo.fdwFlags |= flagsToSet;
        sipInfo.fdwFlags &= ~flagsToClear;
        SHSipInfo(SPI_SETSIPINFO, 0, &sipInfo, 0);
        if (flagsToSet & SIPF_ON)
        {
            RECT rect = sipInfo.rcSipRect;
            ScreenRectToClientRect(hwnd, &rect);
            InvalidateRect(hwnd, &rect, FALSE);
        }
    }
}

void ShowSIP(HWND hwnd)
{
    ModifySIP(hwnd, SIPF_ON | SIPF_DISABLECOMPLETION, 0);
}

void HideSIP(HWND hwnd)
{
    ModifySIP(hwnd, 0, SIPF_ON);
}

#endif