/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#ifndef __AGMLDLLMANAGER_H__
#define __AGMLDLLMANAGER_H__

#include <AGTypes.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

struct AGReader;
struct AGDBConfig;
struct AGRecord;

/* Function prototype typedefs for the functions exposed by the client
 DLLs. */
typedef void * (CALLBACK * INITFUNC)(AGServerConfig * serverConfig);
typedef void (CALLBACK * TERMFUNC)(void *out);

typedef struct {
    HMODULE hAGDatabaseLib;
    INITFUNC InitFunc;
    TERMFUNC TermFunc;
    AGOpenDatabaseFunc OpenDatabaseFunc;
    AGPerformCommandFunc PerformCommandFunc;
    AGGetNextRecordFunc GetNextRecordFunc;
    AGGetNextModifiedRecordFunc GetNextModifiedRecordFunc;
    AGGetNextExpansionCommandFunc GetNextExpansionCommandFunc;
    void * out;
} AGMLDLLManagerDatabase;

typedef struct AGMLDLLManagerServer {
    HKEY registryKey;
    AGServerConfig * serverConfig;
    AGMLDLLManagerDatabase * currentDatabaseInfo;
} AGMLDLLManagerServer;

typedef struct AGMLDLLManager {
    AGMLDLLManagerServer * currentServerInfo;
} AGMLDLLManager;

AGMLDLLManager * AGMLDLLManagerNew(void);
void AGMLDLLManagerFree(AGMLDLLManager * dm);
int32 AGMLDLLManagerPerformCommand(AGMLDLLManager * dll,
                                   int32 *errCode, AGReader *command);
int32 AGMLDLLManagerOpenDatabase(AGMLDLLManager * dll,
                                 AGDBConfig * db,
                                 int32 *errCode);
int32 AGMLDLLManagerGetNextModifiedRecord(AGMLDLLManager * dll,
                                          AGRecord ** record,
                                          int32 *errCode);
int32 AGMLDLLManagerGetNextRecord(AGMLDLLManager * dll,
                                  AGRecord ** record,
                                  int32 *errCode);
int32 AGMLDLLManagerStartServer(AGMLDLLManager * dll,
                                AGServerConfig * serverConfig);
int32 AGMLDLLManagerEndServer(AGMLDLLManager * dll);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* #ifndef __AGMLDLLMANAGER_H__ */