/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#ifndef __PROGRESSPANEL_H__
#define __PROGRESSPANEL_H__

#include <Pilot.h>

#define PROGRESS_NOT_HANDLED        0
#define PROGRESS_HANDLED            1
#define PROGRESS_CANCELED           2

typedef struct ProgressPanel {
    char *taskName;
    char *itemName;
    char *itemCountStr;
    unsigned long totalItems;
    unsigned long currentItem;

    FormPtr  form;
    FieldPtr taskFld;
    FieldPtr itemFld;
    FieldPtr itemCountFld;
    ControlPtr cancelButton;
} ProgressPanel;

extern void ProgressPanelInit(ProgressPanel *panel);
extern void ProgressPanelFinalize(ProgressPanel *panel);

extern void ProgressPanelShow(ProgressPanel *panel);

extern void ProgressPanelSetTask(ProgressPanel *panel, char *taskName);
extern void ProgressPanelSetItem(ProgressPanel *panel, char *item, 
                    int currentItem, int totalItems);

extern int ProgressPanelHandleEvent(ProgressPanel *panel, EventPtr event);

#endif
