/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#include <progresspanel.h>
#include <mobilelinkRsc.h>

#define BAR_X               8
#define BAR_Y               61
#define BAR_WIDTH           140
#define BAR_HEIGHT          10
#define MAX_ITEM_COUNT_STR  20
#define MAX_TASK_STR        100
#define MAX_ITEM_STR        50

static void drawTask(ProgressPanel *panel);
static void drawItemAndBar(ProgressPanel *panel);

void ProgressPanelInit(ProgressPanel *panel)
{
    int index;

    MemSet(panel, sizeof(ProgressPanel), 0);
    panel->form = FrmInitForm(ProgressPanelForm);

    index = FrmGetObjectIndex(panel->form, ProgressPanelTaskNameField);
    panel->taskFld = FrmGetObjectPtr(panel->form, index);

    index = FrmGetObjectIndex(panel->form, ProgressPanelItemNameField);
    panel->itemFld = FrmGetObjectPtr(panel->form, index);

    index = FrmGetObjectIndex(panel->form, ProgressPanelCancelButton);
    panel->cancelButton = FrmGetObjectPtr(panel->form, index);

    index = FrmGetObjectIndex(panel->form, ProgressPanelItemCountField);
    panel->itemCountFld = FrmGetObjectPtr(panel->form, index);

    panel->itemCountStr = MemPtrNew(MAX_ITEM_COUNT_STR);
    MemSet(panel->itemCountStr, MAX_ITEM_COUNT_STR, 0);
    panel->itemName = MemPtrNew(MAX_ITEM_STR);
    MemSet(panel->itemName, MAX_ITEM_STR, 0);
    panel->taskName = MemPtrNew(MAX_TASK_STR);
    MemSet(panel->taskName, MAX_TASK_STR, 0);

    FldSetTextPtr(panel->taskFld, panel->taskName);
    FldSetTextPtr(panel->itemFld, panel->itemName);
    FldSetTextPtr(panel->itemCountFld, panel->itemCountStr);
}

void ProgressPanelFinalize(ProgressPanel *panel)
{
    if(panel->taskName != NULL)
        MemPtrFree(panel->taskName);
    if(panel->itemName != NULL)
        MemPtrFree(panel->itemName);
    if(panel->itemCountStr != NULL)
        MemPtrFree(panel->itemCountStr);
    FrmReturnToForm(0); //Deletes and Erases (panel->form)
    panel->form = NULL;
}

void ProgressPanelShow(ProgressPanel *panel)
{
    FrmSetActiveForm(panel->form);
    FrmDrawForm(panel->form);
    drawTask(panel);
    drawItemAndBar(panel);
}

void ProgressPanelSetTask(ProgressPanel *panel, char *taskName)
{
    int len;

    if(taskName != NULL && *taskName != NULL) {
        len = StrLen(taskName);
        len = len > MAX_TASK_STR - 1 ? MAX_TASK_STR - 1 : len;
        MemMove(panel->taskName, taskName, len);
        *(panel->taskName+len) = 0;
    } 
    FldSetTextPtr(panel->taskFld, panel->taskName);
    FldRecalculateField(panel->taskFld, true);

    drawTask(panel);
    ProgressPanelSetItem(panel, " ", 0, 0);
}

void ProgressPanelSetItem(ProgressPanel *panel, char *itemName, int currentItem,
                            int totalItems)
{ 
    char num[10];
    int len;

    panel->currentItem = currentItem;
    panel->totalItems = totalItems;

    if(panel->currentItem > panel->totalItems)
        panel->currentItem = panel->totalItems;

    MemSet(panel->itemCountStr, MAX_ITEM_COUNT_STR, 0);
    if(totalItems > 0) {
        StrIToA(num, currentItem);
        StrCat(panel->itemCountStr, num);
        StrCat(panel->itemCountStr, " of ");
        StrIToA(num,totalItems);
        StrCat(panel->itemCountStr, num);
    }
    FldSetTextPtr(panel->itemCountFld, panel->itemCountStr);
    FldRecalculateField(panel->itemCountFld, true);

    if(itemName != NULL && *itemName != NULL) {
        len = StrLen(itemName);
        len = len > MAX_ITEM_STR - 1 ? MAX_ITEM_STR - 1 : len;
        MemMove(panel->itemName, itemName, len);
        *(panel->itemName+len) = 0;
    } 
    FldSetTextPtr(panel->itemFld, panel->itemName);
    FldRecalculateField(panel->itemFld, true);

    drawItemAndBar(panel);  
}

int ProgressPanelHandleEvent(ProgressPanel *panel, EventPtr event)
{
        if(event->eType == ctlSelectEvent
          && event->data.ctlSelect.controlID == ProgressPanelCancelButton) {
            return PROGRESS_CANCELED;
        } else {
            if(CtlHandleEvent(panel->cancelButton, event))
                return PROGRESS_HANDLED;
        }
    return PROGRESS_NOT_HANDLED;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

static void drawTask(ProgressPanel *panel)
{
    FldDrawField(panel->taskFld);
}

static void drawItemAndBar(ProgressPanel *panel)
{
    RectangleType r;

    // update the fields
    FldDrawField(panel->itemFld);
    FldDrawField(panel->itemCountFld);

    // Draw Bar properly
    r.topLeft.x = BAR_X;
    r.topLeft.y = BAR_Y;
    r.extent.x  = BAR_WIDTH;
    r.extent.y  = BAR_HEIGHT;

    if(panel->totalItems < 1)   {
        WinEraseRectangleFrame(rectangleFrame, &r);
        WinEraseRectangle(&r, 0);
        return;
    }

    WinDrawRectangleFrame(rectangleFrame, &r);

    // Draw the filled black area
    r.extent.x = (panel->currentItem * (unsigned long)BAR_WIDTH) 
                    / panel->totalItems;
    if(r.extent.x > BAR_WIDTH) 
        r.extent.x = BAR_WIDTH;
    if(r.extent.x < 0)
        r.extent.x = 0;
    WinDrawRectangle(&r, 0);

    // Erase the remaining white area
    r.topLeft.x += r.extent.x + 1;
    r.extent.x = BAR_WIDTH - r.extent.x - 1;
    if(r.topLeft.x < (BAR_WIDTH + BAR_X))
       WinEraseRectangle(&r, 0);
}

