/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#include <Pilot.h>
#include <Common.h>

#include <mobilelinkRsc.h>
#include <password.h>

char* password;

static Boolean passwordFormHandleEvent(EventPtr event)
{
    Boolean handled;
    FormPtr form;

    form = FrmGetActiveForm();

    switch (event->eType) {
    case frmOpenEvent:
        FrmDrawForm(form);
        handled = true;
        break;

    case frmCloseEvent:
        handled = false; /* let the usual form cleanup happen now */
        break;

    case ctlSelectEvent: /* they hit a button */
        if (event->data.ctlEnter.controlID == PasswordOkButton) {
            int      index = FrmGetObjectIndex(form, PasswordPasswordField);
            FieldPtr fieldPtr = (FieldPtr)FrmGetObjectPtr(form, index);
            CharPtr  s;
	    UInt     len;

            /* get the string */
            s = FldGetTextPtr(fieldPtr);
	    if (s == NULL)
		s = "";

	    len = StrLen(s);
	    password = (char*)MemPtrNew((ULong)len + 1);
	    StrCopy(password, s);
        }
        handled = false; /* let regular stuff happen */
        break;

    default:
        handled = false;
    }

    return handled;
}

char* PwdDialogDo()
{
    FormPtr form;
    Word    id;
    int     index;
    
    password = NULL;

    /* Initialize the form */
    form = FrmInitForm(PasswordForm);
    FrmSetEventHandler(form, passwordFormHandleEvent);

    /* set focus */
    index = FrmGetObjectIndex(form, PasswordPasswordField);
    FrmSetFocus(form, index);

    /* process the form */
    id = FrmDoDialog(form);

    /* destroy */
    FrmDeleteForm(form);

    return password;
}
