/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#ifndef __PALMMAL_H__
#define __PALMMAL_H__

#include <AGTypes.h>

#define PALM_OS_NAME  "PALM_OS"
#define WINCE_OS_NAME "WINCE_OS"

typedef enum {
    PALMMAL_OK = 0,
    PALMMAL_ERR,
    PALMMAL_DB_FIND_ERR,
    PALMMAL_DB_OPEN_ERR,
    PALMMAL_RECORD_NOT_FOUND
} PalmMalError;

typedef struct {
    uint32   fileHandle;      // DmOpenRef of the database
    uint32   recId;           // The uid of the record
    uint16   recIndex;        // the index of the record
    uint8    attribs;         // record attribs
    uint32   recSize;         // record size
    uint8    *pBytes;         // record data
} PalmMalCRawRecordInfo;

extern int32 PalmMalOpenDB(char *name, int32 cardNum, int32 mode,  uint32 *handle);
extern int32 PalmMalCreateDB(int32 creator, int32 flags, int32 cardNum, 
                        char *name, int32 type, uint32 *handle);
extern int32 PalmMalCloseDB(uint32 handle);
extern int32 PalmMalDeleteDB(char *name, int32 cardNum);
extern int32 PalmMalGetDBRecordCount(uint32 handle, int32 *recCount);
extern int32 PalmMalPurgeDeletedRecs(uint32 handle);
extern int32 PalmMalResetSyncFlags(uint32 handle);
// ReadRec methods will lock the record handle, you must call PalmMalCloseRecord
// to release the handle when you are done with the record.
extern int32 PalmMalReadRecordByIndex(PalmMalCRawRecordInfo *rec);
extern int32 PalmMalReadRecordById(PalmMalCRawRecordInfo *rec);
extern int32 PalmMalReadNextModifiedRec(PalmMalCRawRecordInfo *rec);
extern int32 PalmMalWriteRecord(PalmMalCRawRecordInfo *rec);
extern int32 PalmMalDeleteRecord(PalmMalCRawRecordInfo *rec);
extern int32 PalmMalAvailableBytes(int32 cardNum, int32 *sizeAvailable);
extern int32 PalmMalCloseRecord(PalmMalCRawRecordInfo *rec);
// You are responsible for freeing the osName and osVersion returned
extern int32 PalmMalGetHardwareConfig(char **osName, char **osVersion, 
                                    int32 *colorDepth, int32 *screenWidth, 
                                    int32 *screenHeight, char **serialNum);
extern int32 PalmMalWriteResource(PalmMalCRawRecordInfo *rec);
extern void PalmMalInit(PalmMalCRawRecordInfo *rRec, uint32 fileHandle,
                                uint32 recId, uint16 recIndex, uint8 attribs,
                                uint32 recSize, uint8 *pBytes);

#endif  /* __PALMMAL_H__ */


