/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#ifdef DEBUG_ON

#ifndef __DEBUG_H__
#define __DEBUG_H__

#include <Pilot.h>

extern void debugLogToDatabase(Boolean logToDb);
extern void debugClearLogDatabase();
extern void debugSetLogging(Boolean shouldLog);

extern void debugAlert(char *fmt, ...);
extern void debugAlertString(char *msg);
extern void debugAlertStrings(char *msg1, char *msg2, char *msg3);
extern void debugAlertInt(char *msg, int num1);

#define debugLocation() { debugAlert("%s @ %i", __FILE__, __LINE__); }

#endif // __DEBUG_H__

#endif // DEBUG_ON

