/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * malglue.c
 *
 * SysLib entry points to libmal.prc.
 * Don't get too cosy with this file, soon it will be generated
 * by a tool.
 *
 * created: djw@avantgo.com, March 18, 1999.
 *
 * Contributor(s):
 */
#define MALGLUE_C /* don't want AG*() functions to be macroised */
#include "libmal.h"

typedef unsigned long register_type;

#if defined(__MWERKS__)

static register_type A4_GET(void) = 0x200C;   /* move.l a5,d0 */
static register_type A5_GET(void) = 0x200D;   /* move.l a5,d0 */
static void A4_SET(register_type x) = 0x2857; /* move.l (sp),a4 */
static void A5_SET(register_type x) = 0x2A57; /* move.l (sp),a5 */

#elif __GNUC__

register register_type reg_a4 asm("%a4");
register register_type reg_a5 asm("%a5");
#define A4_GET() reg_a4
#define A5_GET() reg_a5
#define A4_SET(x) reg_a4 = (register_type)(x)
#define A5_SET(x) reg_a5 = (register_type)(x)

#else

#error "no compiler defined, not sure how to do assembler"

#endif

Err  callLibOpen(UInt refnum);
Err  callLibClose(UInt refnum);
Err  callLibSleep(UInt refnum);
Err  callLibWake(UInt refnum);

/*
 * It looks as though PalmOS needs A5 for PalmOS thingies in addition
 * to just using A5 as the globals register. Gcc generates A4 relative
 * data, and we think we can make MW do the same for libraries, in
 * which case maybe we do not need to save A5. But we do need to save
 * A4 if we want to have stacked shared libraries.
 */
#ifdef __MWERKS__
/*
 * I can't find a way to stop MW from using A4 for general register
 * allocation, so saving it is moot. We'll need to do production builds
 * with gcc until we can solve this.
 */
#define SAVE_A5
#define SAVE_A4
#else
/*
 * In the current release of GCC, it only makes sense to save A4,
 * as A5 is common to all libs.
 */
#define SAVE_A4
#endif

#ifdef DEBUG_djw
void Trap8(void) = 0x4e48;
#else
#define Trap8()
#endif

#if defined(SAVE_A5) && defined(SAVE_A4)

#define PREAMBLE() \
    register_type save_a4;                             \
    register_type save_a5;                             \
    register_type tmp;                                 \
    SysLibTblEntryPtr entryP;                          \
    Trap8();                                           \
    save_a4 = A4_GET();                                \
    save_a5 = A5_GET();                                \
    entryP = SysLibTblEntry(refnum);                   \
    tmp = (register_type)entryP->globalsP;             \
    A4_SET(tmp);                                       \
    A5_SET(tmp)

#define POSTAMBLE() \
    A4_SET(save_a4); \
    A5_SET(save_a5)

#elif defined(SAVE_A5)

#define PREAMBLE() \
    register_type save_a5; \
    SysLibTblEntryPtr entryP; \
    Trap8();                                           \
    save_a5 = A5_GET();                          \
    entryP = SysLibTblEntry(refnum); \
    A5_SET((register_type)entryP->globalsP)

#define POSTAMBLE() \
    A5_SET(save_a5);

#elif defined(SAVE_A4)
#define PREAMBLE() \
    register_type save_a4;                          \
    SysLibTblEntryPtr entryP; \
    Trap8();                                           \
    save_a4 = A4_GET();                          \
    entryP = SysLibTblEntry(refnum); \
    A4_SET((register_type)entryP->globalsP)

#define POSTAMBLE() \
    A4_SET(save_a4);

#else

#error "No globals register save defined"

#endif

static void
callAGBufferReaderFinalize(UInt refnum, AGBufferReader *reader)
{
    PREAMBLE();

    AGBufferReaderFinalize(reader);

    POSTAMBLE();
}

static void
callAGBufferReaderFree(UInt refnum, AGBufferReader *reader)
{
    PREAMBLE();

    AGBufferReaderFree(reader);

    POSTAMBLE();
}

static AGBufferReader*
callAGBufferReaderInit(UInt refnum, AGBufferReader *reader, uint8 *buf)
{
    AGBufferReader* rv;

    PREAMBLE();

    rv = AGBufferReaderInit(reader, buf);

    POSTAMBLE();

    return rv;
}

static AGBufferReader*
callAGBufferReaderNew(UInt refnum, uint8 *buf)
{
    AGBufferReader* rv;

    PREAMBLE();

    rv = AGBufferReaderNew(buf);

    POSTAMBLE();

    return rv;
}

static uint8*
callAGBufferReaderPeek(UInt refnum, AGBufferReader *reader)
{
    uint8* rv;
    PREAMBLE();

    rv = AGBufferReaderPeek(reader);

    POSTAMBLE();

    return rv;
}

static void
callAGBufferWriterFinalize(UInt refnum, AGBufferWriter *writer)
{
    PREAMBLE();

    AGBufferWriterFinalize(writer);

    POSTAMBLE();
}

static uint8*
callAGBufferWriterGetBuffer(UInt refnum, AGBufferWriter *writer)
{
    uint8* rv;
    PREAMBLE();

    rv = AGBufferWriterGetBuffer(writer);

    POSTAMBLE();

    return rv;
}

static uint32
callAGBufferWriterGetBufferSize(UInt refnum, AGBufferWriter *writer)
{
    uint32 rv;
    PREAMBLE();

    rv = AGBufferWriterGetBufferSize(writer);

    POSTAMBLE();

    return rv;
}

static AGBufferWriter*
callAGBufferWriterInit(UInt refnum, AGBufferWriter *writer, uint32 cacheSize)
{
    AGBufferWriter* rv;
    PREAMBLE();

    rv = AGBufferWriterInit(writer, cacheSize);

    POSTAMBLE();

    return rv;
}

static uint8*
callAGBufferWriterRemoveBuffer(UInt refnum, AGBufferWriter *writer)
{
    uint8* rv;
    PREAMBLE();

    rv = AGBufferWriterRemoveBuffer(writer);

    POSTAMBLE();

    return rv;
}

static void
callAGBufferWriterReset(UInt refnum, AGBufferWriter *writer)
{
    PREAMBLE();

    AGBufferWriterReset(writer);

    POSTAMBLE();
}

static int32
callAGBufferWriterWrite(UInt refnum, void *aWriter, void *src, int32 len)
{
    int32 rv;
    PREAMBLE();

    rv = AGBufferWriterWrite(aWriter, src, len);

    POSTAMBLE();

    return rv;
}

static void
callAGClientProcessorFinalize(UInt refnum, AGClientProcessor *processor)
{
    PREAMBLE();

    AGClientProcessorFinalize(processor);

    POSTAMBLE();
}

static AGClientProcessor*
callAGClientProcessorInit(UInt refnum,
			  AGClientProcessor *processor,
			  AGServerConfig *serverInfo,
			  AGDeviceInfo *deviceInfo,
			  AGLocationConfig *lc,
			  AGPlatformCalls *platformCalls,
			  AGBool bufferCommands,
			  AGNetCtx *netctx)
{
    AGClientProcessor* rv;
    PREAMBLE();

    rv = AGClientProcessorInit(processor,
			       serverInfo,
			       deviceInfo,
			       lc,
			       platformCalls,
			       bufferCommands,
			       netctx);

    POSTAMBLE();

    return rv;
}

static int32
callAGClientProcessorProcess(UInt refnum, AGClientProcessor *processor)
{
    int32 rv;
    PREAMBLE();

    rv = AGClientProcessorProcess(processor);

    POSTAMBLE();

    return rv;
}

static void
callAGClientProcessorSync(UInt refnum, AGClientProcessor *processor)
{
    PREAMBLE();

    AGClientProcessorSync(processor);

    POSTAMBLE();
}

static void
callAGCommandProcessorFinalize(UInt refnum, AGCommandProcessor *processor)
{
    PREAMBLE();

    AGCommandProcessorFinalize(processor);

    POSTAMBLE();
}

static AGPerformCommandFunc
callAGCommandProcessorGetPerformFunc(UInt refnum, AGCommandProcessor* processor)
{
    AGPerformCommandFunc rv;
    PREAMBLE();

    rv = AGCommandProcessorGetPerformFunc(processor);

    POSTAMBLE();

    return rv;
}

static AGCommandProcessor*
callAGCommandProcessorInit(UInt refnum,
			   AGCommandProcessor *processor,
			   AGServerConfig *server)
{
    AGCommandProcessor* rv;
    PREAMBLE();

    rv = AGCommandProcessorInit(processor, server);

    POSTAMBLE();

    return rv;
}

static AGBool
callAGCommandProcessorShouldSyncAgain(UInt refnum, AGCommandProcessor* processor)
{
    AGBool rv;
    PREAMBLE();

    rv = AGCommandProcessorShouldSyncAgain(processor);

    POSTAMBLE();

    return rv;
}

static int32
callAGCommandProcessorStart(UInt refnum, AGCommandProcessor *processor)
{
    int32 rv;
    PREAMBLE();

    rv = AGCommandProcessorStart(processor);

    POSTAMBLE();

    return rv;
}

static void
callAGDeviceInfoFinalize(UInt refnum, AGDeviceInfo *deviceInfo)
{
    PREAMBLE();

    AGDeviceInfoFinalize(deviceInfo);

    POSTAMBLE();
}

static AGDeviceInfo*
callAGDeviceInfoInit(UInt refnum, AGDeviceInfo *deviceInfo)
{
    AGDeviceInfo* rv;
    PREAMBLE();

    rv = AGDeviceInfoInit(deviceInfo);

    POSTAMBLE();

    return rv;
    
}

static sword
callAGNetClose(UInt refnum, AGNetCtx *ctx)
{
    sword rv;
    PREAMBLE();

    rv = AGNetClose(ctx);

    POSTAMBLE();

    return rv;
}

static sword
callAGNetInit(UInt refnum, AGNetCtx *ctx)
{
    sword rv;
    PREAMBLE();

    rv = AGNetInit(ctx);

    POSTAMBLE();

    return rv;
}

static void
callAGNetSetIOFuncs(UInt refnum,
		  AGNetCtx *ctx,
		  AGNetSendFunc send,
		  AGNetConnectFunc connect,
		  AGNetReadFunc recv,
		  AGNetCloseFunc close,
		  AGNetSocketNewFunc socnew,
		  AGNetSocketFreeFunc socfree,
		  AGNetReadProtectedFunc recvdm)
{
    PREAMBLE();

    AGNetSetIOFuncs(ctx,
		    send,
		    connect,
		    recv,
		    close,
		    socnew,
		    socfree,
		    recvdm);

    POSTAMBLE();
}

static char*
callAGGetMsg(UInt refnum, uint32 msgId)
{
    char* rv;
    PREAMBLE();

    rv = AGGetMsg(msgId);

    POSTAMBLE();

    return rv;
}

static uint8
callAGPalmMALModToPilotAttribs(UInt refnum, AGRecordStatus mod)
{
    uint8 rv;
    PREAMBLE();

    rv = AGPalmMALModToPilotAttribs(mod);

    POSTAMBLE();

    return rv;
}

static AGRecordStatus
callAGPalmPilotAttribsToMALMod(UInt refnum, uint8 attrib)
{
    AGRecordStatus rv;
    PREAMBLE();

    rv = AGPalmPilotAttribsToMALMod(attrib);

    POSTAMBLE();

    return rv;
}

static void
callAGPalmReadDBConfigPlatformData(UInt refnum,
				 AGReader *r,
				 uint32 *creator, uint32 *type, uint32 *flags)
{
    PREAMBLE();

    AGPalmReadDBConfigPlatformData(r, creator, type, flags);

    POSTAMBLE();
}

static void
callAGPalmReadRecordPlatformData(UInt refnum, AGReader *r, int16 *recordIndex)
{
    PREAMBLE();

    AGPalmReadRecordPlatformData(r, recordIndex);

    POSTAMBLE();
}

static uint16
callAGReadInt16(UInt refnum, AGReader *r)
{
    uint16 rv;
    PREAMBLE();

    rv = AGReadInt16(r);

    POSTAMBLE();

    return rv;
}

static uint32
callAGReadInt32(UInt refnum, AGReader *r)
{
    uint32 rv;
    PREAMBLE();

    rv = AGReadInt32(r);

    POSTAMBLE();

    return rv;
}

static uint8
callAGReadInt8(UInt refnum, AGReader *r)
{
    uint8 rv;
    PREAMBLE();

    rv = AGReadInt8(r);

    POSTAMBLE();

    return rv;
}

static char *
callAGReadProtectedCString(UInt refnum, AGBufferReader *reader)
{
    char* rv;
    PREAMBLE();

    rv = AGReadProtectedCString(reader);

    POSTAMBLE();

    return rv;
}

static AGDBConfig*
callAGServerConfigGetDBConfigNamed(UInt refnum,
				   AGServerConfig *config, char *dbname)
{
    AGDBConfig* rv;
    PREAMBLE();

    rv = AGServerConfigGetDBConfigNamed(config, dbname);

    POSTAMBLE();

    return rv;
}

static uint32
callAGSkipCString(UInt refnum, AGReader *r)
{
    uint32 rv;

    PREAMBLE();

    rv = AGSkipCString(r);

    POSTAMBLE();

    return rv;
}

static uint32
callAGTime(UInt refnum)
{
    uint32 rv;

    PREAMBLE();
    rv = AGTime();
    POSTAMBLE();

    return rv;
}

static int32
callAGUserConfigCount(UInt refnum, AGUserConfig * serverList)
{
    int32 rv;
    PREAMBLE();

    rv = AGUserConfigCount(serverList);

    POSTAMBLE();

    return rv;
}

static void
callAGUserConfigFree(UInt refnum, AGUserConfig * serverList)
{
    PREAMBLE();

    AGUserConfigFree(serverList);

    POSTAMBLE();
}

static AGServerConfig*
callAGUserConfigGetServerByIndex(UInt refnum,
			       AGUserConfig * serverList, int32 index)
{
    AGServerConfig* rv;
    PREAMBLE();

    rv = AGUserConfigGetServerByIndex(serverList, index);

    POSTAMBLE();

    return rv;
}

static AGUserConfig *
callAGUserConfigNewAndReadData(UInt refnum, AGReader *r)
{
    AGUserConfig* rv;
    PREAMBLE();

    rv = AGUserConfigNewAndReadData(r);

    POSTAMBLE();

    return rv;
}

static void
callAGUserConfigResetCookies(UInt refnum, AGUserConfig *config)
{
    PREAMBLE();

    AGUserConfigResetCookies(config);

    POSTAMBLE();
}

static void
callAGUserConfigWriteData(UInt refnum, AGUserConfig * serverList, AGWriter *w)
{
    PREAMBLE();

    AGUserConfigWriteData(serverList, w);

    POSTAMBLE();
}

static uint32
callAGWriteBytes(UInt refnum, AGWriter *w, void *buf, int32 len)
{
    uint32 rv;
    PREAMBLE();

    rv = AGWriteBytes(w, buf, len);

    POSTAMBLE();

    return rv;
}

static void
callAGWriteCString(UInt refnum, AGWriter *w, char *str)
{
    PREAMBLE();

    AGWriteCString(w, str);

    POSTAMBLE();
}

static void
callAGWriteCompactInt(UInt refnum, AGWriter *w, uint32 val)
{
    PREAMBLE();

    AGWriteCompactInt(w, val);

    POSTAMBLE();
}

static void
callAGWriteInt16(UInt refnum, AGWriter *w, uint16 val)
{
    PREAMBLE();

    AGWriteInt16(w, val);

    POSTAMBLE();
}

static void
callAGWriteInt32(UInt refnum, AGWriter *w, uint32 val)
{
    PREAMBLE();

    AGWriteInt32(w, val);

    POSTAMBLE();
}

static void
callAGWriteInt8(UInt refnum, AGWriter *w, uint8 val)
{
    PREAMBLE();

    AGWriteInt8(w, val);

    POSTAMBLE();
}

static void
callAGWriterFinalize(UInt refnum, AGWriter *w)
{
    PREAMBLE();

    AGWriterFinalize(w);

    POSTAMBLE();
}

static AGWriter*
callAGWriterInit(UInt refnum, AGWriter *w, void *in, AGWriteFunc writeFunc)
{
    AGWriter* rv;

    PREAMBLE();

    rv = AGWriterInit(w, in, writeFunc);

    POSTAMBLE();

    return rv;
}

static AGClientProcessor*
callAGClientProcessorNew(UInt refnum,
			 AGServerConfig *serverInfo,
			 AGDeviceInfo *deviceInfo,
			 AGLocationConfig *lc,
			 AGPlatformCalls *platformCalls,
			 AGBool bufferCommands,
			 AGNetCtx *netctx)
{
    AGClientProcessor* rv;

    PREAMBLE();

    rv = AGClientProcessorNew(serverInfo,
			      deviceInfo,
			      lc,
			      platformCalls,
			      bufferCommands,
			      netctx);
    
    POSTAMBLE();

    return rv;
}

static void
callAGClientProcessorFree(UInt refnum, AGClientProcessor *processor)
{
    PREAMBLE();

    AGClientProcessorFree(processor);

    POSTAMBLE();
}

static void
callAGProtectedMemoryFinalize(UInt refnum)
{
    PREAMBLE();

    AGProtectedMemoryFinalize();

    POSTAMBLE();
}

static AGBool
callAGServerConfigIsValid(UInt refnum, AGServerConfig *config)
{
    AGBool rv;

    PREAMBLE();

    rv = AGServerConfigIsValid(config);

    POSTAMBLE();

    return rv;
}

static void
callAGUserConfigInit(UInt refnum, AGUserConfig * serverList)
{
    PREAMBLE();

    AGUserConfigInit(serverList);

    POSTAMBLE();
}

static int32
callAGUserConfigAddServer(UInt refnum,
			  AGUserConfig* serverList,
			  AGServerConfig* serverConfig)
{
    int32 rv;

    PREAMBLE();

    rv = AGUserConfigAddServer(serverList, serverConfig);

    POSTAMBLE();

    return rv;
}

static void
callAGUserConfigFinalize(UInt refnum, AGUserConfig * serverList)
{
    PREAMBLE();

    AGUserConfigFinalize(serverList);

    POSTAMBLE();
}

static void
callAGServerConfigResetCookie(UInt refnum, AGServerConfig *config)
{
    PREAMBLE();

    AGServerConfigResetCookie(config);

    POSTAMBLE();
}

static AGServerConfig*
callAGServerConfigNew(UInt refnum)
{
    AGServerConfig* rv;

    PREAMBLE();

    rv = AGServerConfigNew();

    POSTAMBLE();

    return rv;
}

static void
callAGMd5(UInt refnum, uint8 *buf, int32 buflen, uint8 digest[16])
{
    PREAMBLE();

    AGMd5(buf, buflen, digest);

    POSTAMBLE();
}

static void
callAGUserConfigRemoveServer(UInt refnum,
			     AGUserConfig * serverList,
			     AGServerConfig * serverConfig)
{
    PREAMBLE();

    AGUserConfigRemoveServer(serverList, serverConfig);

    POSTAMBLE();
}

static int16
callAGProtectedMemoryInit(UInt refnum)
{
    int16 rv;

    PREAMBLE();

    rv = AGProtectedMemoryInit();

    POSTAMBLE();

    return rv;
}

static AGUserConfig*
callAGUserConfigInitAndReadData(UInt refnum,
				AGUserConfig* userConfig,
				AGReader*     r)
{
    AGUserConfig* rv;

    PREAMBLE();

    rv = AGUserConfigInitAndReadData(userConfig, r);

    POSTAMBLE();

    return rv;
}

static uint8*
callAGBase64Decode(UInt refnum, char *source, int32 *len)
{
    uint8* rv;

    PREAMBLE();

    rv = (uint8*)AGBase64Decode(source, len);

    POSTAMBLE();

    return rv;
}

static char*
callAGBase64Encode(UInt refnum, char *source, int32 len)
{
    char* rv;

    PREAMBLE();

    rv = (char*)AGBase64Encode((unsigned char*)source, len);

    POSTAMBLE();

    return rv;
}
static AGBool
callAGNetCanDoSecure(UInt refnum, AGNetCtx *ctx)
{
    AGBool rv;

    PREAMBLE();

    rv = AGNetCanDoSecure(ctx);

    POSTAMBLE();

    return rv;
}
static int32
callAGNetGetCtxSize(UInt refnum)
{
    int32 rv;

    PREAMBLE();

    rv = AGNetGetCtxSize();

    POSTAMBLE();

    return rv;
}
static void
callAGNetToggle(UInt refnum, AGNetCtx *ctx, AGBool tog)
{
    PREAMBLE();

    AGNetToggle(ctx, tog);

    POSTAMBLE();

}

Err
callLibOpen(UInt refnum)
{
#if 0
    /* nothing to do */
    PREAMBLE();

    POSTAMBLE();
#endif

    return 0;
}

void _shlib_end(void* globals);

Err
callLibClose(UInt refnum)
{
    SysLibTblEntryPtr entryP;

#if 0
    /* nothing to do */
    PREAMBLE();

    POSTAMBLE();
#endif

    /* Do this last, globals and code segments are gone afterwards */
    entryP = SysLibTblEntry(refnum);
    _shlib_end(entryP->globalsP);
    entryP->globalsP = 0;

    return 0;
}

Err
callLibSleep(UInt refnum)
{
    return 0;
}

Err
callLibWake(UInt refnum)
{
    return 0;
}

Ptr* ShlibGetDispatchTable();

#if defined(__MWERKS__)
Ptr asm *ShlibGetDispatchTable()
{
    lea jmptable,a0
    rts
jmptable:
    dc.w 446 /* 6n+2 */

    dc.w 150 /* 2n + 4i - 2 */
    dc.w 154
    dc.w 158
    dc.w 162
    dc.w 166
    dc.w 170
    dc.w 174
    dc.w 178
    dc.w 182
    dc.w 186
    dc.w 190
    dc.w 194
    dc.w 198
    dc.w 202
    dc.w 206
    dc.w 210
    dc.w 214
    dc.w 218
    dc.w 222
    dc.w 226
    dc.w 230
    dc.w 234
    dc.w 238
    dc.w 242
    dc.w 246
    dc.w 250
    dc.w 254
    dc.w 258
    dc.w 262
    dc.w 266
    dc.w 270
    dc.w 274
    dc.w 278
    dc.w 282
    dc.w 286
    dc.w 290
    dc.w 294
    dc.w 298
    dc.w 302
    dc.w 306
    dc.w 310
    dc.w 314
    dc.w 318
    dc.w 322
    dc.w 326
    dc.w 330
    dc.w 334
    dc.w 338
    dc.w 342
    dc.w 346
    dc.w 350
    dc.w 354
    dc.w 358
    dc.w 362
    dc.w 366
    dc.w 370
    dc.w 374
    dc.w 378
    dc.w 382
    dc.w 386
    dc.w 390
    dc.w 394
    dc.w 398
    dc.w 402
    dc.w 406
    dc.w 410
    dc.w 414
    dc.w 418
    dc.w 422
    dc.w 426
    dc.w 430
    dc.w 434
    dc.w 438
    dc.w 442

    jmp callLibOpen
    jmp callLibClose
    jmp callLibSleep
    jmp callLibWake
    jmp callAGBufferReaderFinalize
    jmp callAGBufferReaderFree
    jmp callAGBufferReaderInit
    jmp callAGBufferReaderNew
    jmp callAGBufferReaderPeek
    jmp callAGBufferWriterFinalize
    jmp callAGBufferWriterGetBuffer
    jmp callAGBufferWriterGetBufferSize
    jmp callAGBufferWriterInit
    jmp callAGBufferWriterRemoveBuffer
    jmp callAGBufferWriterReset
    jmp callAGBufferWriterWrite
    jmp callAGClientProcessorFinalize
    jmp callAGClientProcessorFree
    jmp callAGClientProcessorInit
    jmp callAGClientProcessorNew
    jmp callAGClientProcessorProcess
    jmp callAGClientProcessorSync
    jmp callAGCommandProcessorFinalize
    jmp callAGCommandProcessorGetPerformFunc
    jmp callAGCommandProcessorInit
    jmp callAGCommandProcessorShouldSyncAgain
    jmp callAGCommandProcessorStart
    jmp callAGDeviceInfoFinalize
    jmp callAGDeviceInfoInit
    jmp callAGGetMsg
    jmp callAGMd5
    jmp callAGNetClose
    jmp callAGNetInit
    jmp callAGNetSetIOFuncs
    jmp callAGPalmMALModToPilotAttribs
    jmp callAGPalmPilotAttribsToMALMod
    jmp callAGPalmReadDBConfigPlatformData
    jmp callAGPalmReadRecordPlatformData
    jmp callAGProtectedMemoryFinalize
    jmp callAGProtectedMemoryInit
    jmp callAGReadInt16
    jmp callAGReadInt32
    jmp callAGReadInt8
    jmp callAGReadProtectedCString
    jmp callAGServerConfigGetDBConfigNamed
    jmp callAGServerConfigIsValid
    jmp callAGServerConfigNew
    jmp callAGServerConfigResetCookie
    jmp callAGSkipCString
    jmp callAGTime
    jmp callAGUserConfigAddServer
    jmp callAGUserConfigCount
    jmp callAGUserConfigFinalize
    jmp callAGUserConfigFree
    jmp callAGUserConfigGetServerByIndex
    jmp callAGUserConfigInit
    jmp callAGUserConfigInitAndReadData
    jmp callAGUserConfigNewAndReadData
    jmp callAGUserConfigRemoveServer
    jmp callAGUserConfigResetCookies
    jmp callAGUserConfigWriteData
    jmp callAGWriteBytes
    jmp callAGWriteCString
    jmp callAGWriteCompactInt
    jmp callAGWriteInt16
    jmp callAGWriteInt32
    jmp callAGWriteInt8
    jmp callAGWriterFinalize
    jmp callAGWriterInit
    jmp callAGBase64Encode
    jmp callAGBase64Decode
    jmp callAGNetCanDoSecure
    jmp callAGNetGetCtxSize
    jmp callAGNetToggle

    dc.b "MAL Library"
}
#elif __GNUC__
asm("
    .globl ShlibGetDispatchTable
ShlibGetDispatchTable:
    lea jmptable(%pc),%a0
    rts
jmptable:
    dc.w 446 /* 6n+2 */

    dc.w 150 /* 2n + 4i - 2 */
    dc.w 154
    dc.w 158
    dc.w 162
    dc.w 166
    dc.w 170
    dc.w 174
    dc.w 178
    dc.w 182
    dc.w 186
    dc.w 190
    dc.w 194
    dc.w 198
    dc.w 202
    dc.w 206
    dc.w 210
    dc.w 214
    dc.w 218
    dc.w 222
    dc.w 226
    dc.w 230
    dc.w 234
    dc.w 238
    dc.w 242
    dc.w 246
    dc.w 250
    dc.w 254
    dc.w 258
    dc.w 262
    dc.w 266
    dc.w 270
    dc.w 274
    dc.w 278
    dc.w 282
    dc.w 286
    dc.w 290
    dc.w 294
    dc.w 298
    dc.w 302
    dc.w 306
    dc.w 310
    dc.w 314
    dc.w 318
    dc.w 322
    dc.w 326
    dc.w 330
    dc.w 334
    dc.w 338
    dc.w 342
    dc.w 346
    dc.w 350
    dc.w 354
    dc.w 358
    dc.w 362
    dc.w 366
    dc.w 370
    dc.w 374
    dc.w 378
    dc.w 382
    dc.w 386
    dc.w 390
    dc.w 394
    dc.w 398
    dc.w 402
    dc.w 406
    dc.w 410
    dc.w 414
    dc.w 418
    dc.w 422
    dc.w 426
    dc.w 430
    dc.w 434
    dc.w 438
    dc.w 442

    jmp callLibOpen(%pc)
    jmp callLibClose(%pc)
    jmp callLibSleep(%pc)
    jmp callLibWake(%pc)
    jmp callAGBufferReaderFinalize(%pc)
    jmp callAGBufferReaderFree(%pc)
    jmp callAGBufferReaderInit(%pc)
    jmp callAGBufferReaderNew(%pc)
    jmp callAGBufferReaderPeek(%pc)
    jmp callAGBufferWriterFinalize(%pc)
    jmp callAGBufferWriterGetBuffer(%pc)
    jmp callAGBufferWriterGetBufferSize(%pc)
    jmp callAGBufferWriterInit(%pc)
    jmp callAGBufferWriterRemoveBuffer(%pc)
    jmp callAGBufferWriterReset(%pc)
    jmp callAGBufferWriterWrite(%pc)
    jmp callAGClientProcessorFinalize(%pc)
    jmp callAGClientProcessorFree(%pc)
    jmp callAGClientProcessorInit(%pc)
    jmp callAGClientProcessorNew(%pc)
    jmp callAGClientProcessorProcess(%pc)
    jmp callAGClientProcessorSync(%pc)
    jmp callAGCommandProcessorFinalize(%pc)
    jmp callAGCommandProcessorGetPerformFunc(%pc)
    jmp callAGCommandProcessorInit(%pc)
    jmp callAGCommandProcessorShouldSyncAgain(%pc)
    jmp callAGCommandProcessorStart(%pc)
    jmp callAGDeviceInfoFinalize(%pc)
    jmp callAGDeviceInfoInit(%pc)
    jmp callAGGetMsg(%pc)
    jmp callAGMd5(%pc)
    jmp callAGNetClose(%pc)
    jmp callAGNetInit(%pc)
    jmp callAGNetSetIOFuncs(%pc)
    jmp callAGPalmMALModToPilotAttribs(%pc)
    jmp callAGPalmPilotAttribsToMALMod(%pc)
    jmp callAGPalmReadDBConfigPlatformData(%pc)
    jmp callAGPalmReadRecordPlatformData(%pc)
    jmp callAGProtectedMemoryFinalize(%pc)
    jmp callAGProtectedMemoryInit(%pc)
    jmp callAGReadInt16(%pc)
    jmp callAGReadInt32(%pc)
    jmp callAGReadInt8(%pc)
    jmp callAGReadProtectedCString(%pc)
    jmp callAGServerConfigGetDBConfigNamed(%pc)
    jmp callAGServerConfigIsValid(%pc)
    jmp callAGServerConfigNew(%pc)
    jmp callAGServerConfigResetCookie(%pc)
    jmp callAGSkipCString(%pc)
    jmp callAGTime(%pc)
    jmp callAGUserConfigAddServer(%pc)
    jmp callAGUserConfigCount(%pc)
    jmp callAGUserConfigFinalize(%pc)
    jmp callAGUserConfigFree(%pc)
    jmp callAGUserConfigGetServerByIndex(%pc)
    jmp callAGUserConfigInit(%pc)
    jmp callAGUserConfigInitAndReadData(%pc)
    jmp callAGUserConfigNewAndReadData(%pc)
    jmp callAGUserConfigRemoveServer(%pc)
    jmp callAGUserConfigResetCookies(%pc)
    jmp callAGUserConfigWriteData(%pc)
    jmp callAGWriteBytes(%pc)
    jmp callAGWriteCString(%pc)
    jmp callAGWriteCompactInt(%pc)
    jmp callAGWriteInt16(%pc)
    jmp callAGWriteInt32(%pc)
    jmp callAGWriteInt8(%pc)
    jmp callAGWriterFinalize(%pc)
    jmp callAGWriterInit(%pc)
    jmp callAGBase64Encode(%pc)
    jmp callAGBase64Decode(%pc)
    jmp callAGNetCanDoSecure(%pc)
    jmp callAGNetGetCtxSize(%pc)
    jmp callAGNetToggle(%pc)

    .ascii \"MAL Library\"
");

#endif

Err ShlibMain(UInt refNum, SysLibTblEntryPtr entryP);

/*
 * You cannot disable the startup code in MW, you must use their startup
 * and provide an entry called ShlibMain.
 */
Err
ShlibMain(UInt refNum, SysLibTblEntryPtr entryP)
{
    /* Call asm code below to install dispatch table */
    entryP->dispatchTblP = ShlibGetDispatchTable();

    /*
     * startup code has set the entryp->globalsP to the shared libraries
     * globals. We can leave it that way or change the value, as long
     * as the PREAMBLE()/POSTAMBLE() code is compatible with the change.
     */
    
    return 0;
}

