/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#include <AGSyncPalmStatusDialog.h>
#include <AGUtil.h>
#include <windowsx.h>
#include <commctrl.h>
#include <AGSyncPalmResource.h>
#include <stdio.h>

/* ----------------------------------------------------------------------------
    static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)

    Handler for WM_COMMAND.


*/
static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    AGSyncPalmStatusDialog * pInfo;

    pInfo = (AGSyncPalmStatusDialog *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case BN_CLICKED:
            switch (id) {
                case IDCANCEL:
                    if (NULL != pInfo->quit)
                        *(pInfo->quit) = TRUE;
            }
            break;
        default:
            break;

    }
}

/* ----------------------------------------------------------------------------
    static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)

    Handler for WM_INITDIALOG.


*/
static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    AGSyncPalmStatusDialog * pInfo;
    HWND hwndIcon;
    LONG iconStyle;
    
    SetWindowLong(hwnd, GWL_USERDATA, lParam);

    pInfo = (AGSyncPalmStatusDialog *)lParam;

    /* Windows requires that a static image have the right style depending
    on whether it will be displaying an icon or a bitmap.
    So we set it here. */
    hwndIcon = GetDlgItem(hwnd, IDC_STATUS_ICON);
    iconStyle = GetWindowLong(hwndIcon, GWL_STYLE);
    if (pInfo->bitmapFormat)
        iconStyle = (iconStyle & ~SS_ICON) | SS_BITMAP;
    else
        iconStyle = (iconStyle & ~SS_BITMAP) | SS_ICON;
    SetWindowLong(hwndIcon, GWL_STYLE, iconStyle);

    /* If there is an array of graphics, set the timer to expire immediately
    so that we update the icon with the first frame right away. */
    if (AGArrayCount(pInfo->graphic) > 0)
        SetTimer(hwnd, 0, 0, NULL);

    return FALSE;
}

/* ----------------------------------------------------------------------------
    static void onTimer(HWND hwnd, UINT id)

    Handler for WM_TIMER.


*/
static void onTimer(HWND hwnd, UINT id)
{
    AGSyncPalmStatusDialog * pInfo;
    HWND hwndIcon;

    pInfo = (AGSyncPalmStatusDialog *)GetWindowLong(hwnd, GWL_USERDATA);

    /* Restart timer. */
    SetTimer(hwnd, 0, pInfo->msecPerFrame, NULL);

    pInfo->currentFrame;

    hwndIcon = GetDlgItem(hwnd, IDC_STATUS_ICON);
    SendMessage(hwndIcon,
        STM_SETIMAGE,
        (pInfo->bitmapFormat) ? IMAGE_BITMAP : IMAGE_ICON,
        (LPARAM)AGArrayElementAt(pInfo->graphic, pInfo->currentFrame));

    pInfo->currentFrame++;

    pInfo->currentFrame %= AGArrayCount(pInfo->graphic);

}

/* ----------------------------------------------------------------------------
    static BOOL CALLBACK dialogProc(HWND hwnd, UINT message,
        WPARAM wParam, LPARAM lParam)

    Window proc for dialog.


*/
static BOOL CALLBACK dialogProc(HWND hwnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
	switch (message) {
		HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
		HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
		HANDLE_MSG(hwnd, WM_TIMER, onTimer);
	}

	return 0;	// except for WM_INITDIALOG, returning zero means
				// we didn't process the message.
}

AGSyncPalmStatusDialog * AGSyncPalmStatusDialogNew(HINSTANCE hInst,
                                                   AGBool * quit,
                                                   AGArray * graphic,
                                                   uint32 msecPerFrame,
                                                   AGBool bitmapFormat)
{
    TCHAR strbuf[256];
    AGSyncPalmStatusDialog * pInfo;

    // Load comctl library.
    InitCommonControls();

    pInfo = (AGSyncPalmStatusDialog*)malloc(sizeof(AGSyncPalmStatusDialog));

    if (NULL == pInfo)
        return NULL;

    memset(pInfo, 0, sizeof(AGSyncPalmStatusDialog));

    pInfo->quit = quit;

    pInfo->graphic = graphic;
    pInfo->currentFrame = 0;
    pInfo->msecPerFrame = msecPerFrame;
    pInfo->bitmapFormat = bitmapFormat;

    LoadString(hInst, IDS_X_OF_Y, strbuf, 256);
    pInfo->x_of_y = strdup(strbuf);

    pInfo->hDlg = CreateDialogParam(hInst, MAKEINTRESOURCE(IDD_STATUS),
        NULL, dialogProc, (LPARAM)pInfo);

    pInfo->hTask = GetDlgItem(pInfo->hDlg, IDC_TASK_TEXT);
    pInfo->hItem = GetDlgItem(pInfo->hDlg, IDC_ITEM_TEXT);
    pInfo->hBar = GetDlgItem(pInfo->hDlg, IDC_PROGRESS);
    pInfo->hx_of_y = GetDlgItem(pInfo->hDlg, IDC_X_OF_Y_TEXT);

    return pInfo;
}

void AGSyncPalmStatusDialogFree(AGSyncPalmStatusDialog * pInfo)
{   
    if (NULL != pInfo) {
        if (NULL != pInfo->hDlg)
            DestroyWindow(pInfo->hDlg);
        if (NULL != pInfo->x_of_y)
            free(pInfo->x_of_y);
        free(pInfo);
    }
}

void AGSyncPalmStatusDialogSetTask(AGSyncPalmStatusDialog * pInfo,
                                   LPCSTR str)
{
    SetWindowText(pInfo->hTask, str);
    UpdateWindow(pInfo->hDlg);
}

void AGSyncPalmStatusDialogSetTitle(AGSyncPalmStatusDialog * pInfo,
                                    LPCSTR str)
{
    SetWindowText(pInfo->hDlg, str);
    UpdateWindow(pInfo->hDlg);
}

void AGSyncPalmStatusDialogSetItem(AGSyncPalmStatusDialog * pInfo,
                                        LPCSTR str)
{
    SetWindowText(pInfo->hItem, str);
    UpdateWindow(pInfo->hDlg);
}

void AGSyncPalmStatusDialogSetBar(AGSyncPalmStatusDialog * pInfo,
                                  int progress, int maximum)
{
    TCHAR buf[32];
    sprintf(buf, pInfo->x_of_y, progress, maximum);
    SetWindowText(pInfo->hx_of_y, buf);

    if (maximum > 0)
        SendMessage(pInfo->hBar, PBM_SETPOS,
        (WPARAM)(progress * 100 / maximum), 0);
    UpdateWindow(pInfo->hDlg);
}