/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : ToolbarPanel.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "ToolbarPanel.h"
#include "ImageListener.h"
#include "ComponentID.h"

#include <mhgui/Window.h>
#include <mhgui/Rect.h>
#include <mhgui/Tooltip.h>

using namespace std;
using namespace Animorph;

ToolbarPanel::ToolbarPanel ()
    : Panel (kComponentID_ToolbarPanel, Rect(192,0,1280,32))
{
}

ToolbarPanel::~ToolbarPanel ()
{
  for_each (imageVector.begin (), imageVector.end (), deleteFunctor <Image*> ());
}

void ToolbarPanel::createWidgets ()
{
  Window &mainWindow = Window::instance ();
  Panel *tooltipPanel = mainWindow.getPanel (kComponentID_TooltipPanel);
  assert(tooltipPanel);

  const Color color_red (1.0, 0.0, 0.0);
  const float alpha = 0.8;
  const Point kTooltipPos(70, 12);

  Image *image;

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_LoadBodysettings,
                    searchPixmapFile ("ui/toolbar_01.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Load bodysetting", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_SaveBodysettings,
                    searchPixmapFile ("ui/toolbar_02.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Save bodysetting", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_ExportWavefrontObj,
                    searchPixmapFile ("ui/toolbar_03.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Export wavefront obj", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_CharacterSettings,
                    searchPixmapFile ("ui/toolbar_04.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Character setting (somatotypes, shapes, age, etc...)", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_BodyDetailsRealistic,
                    searchPixmapFile ("ui/toolbar_05.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Body details (realistic morphings)", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_BodyDetailsFantasy,
                    searchPixmapFile ("ui/toolbar_06.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Body details (fantasy morphings)", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_Clothes,
                    searchPixmapFile ("ui/toolbar_07.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Clothes", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_Poses,
                    searchPixmapFile ("ui/toolbar_08.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Poses", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_Lights,
                    searchPixmapFile ("ui/toolbar_09.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Lights", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_Expressions,
                    searchPixmapFile ("ui/toolbar_10.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Expressions", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_Asymmetry,
                    searchPixmapFile ("ui/toolbar_11.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Asymmetry", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_Hairs,
                    searchPixmapFile ("ui/toolbar_12.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Hairs", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_Materials,
                    searchPixmapFile ("ui/toolbar_13.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Materials", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_ImageToolbarPanel_Rendering,
                    searchPixmapFile ("ui/toolbar_14.png"),
                    Rect(0,0,32,32));
  image->setListener(&imgListener1);
  image->setTooltip(Tooltip("Rendering", kTooltipPos, color_red, tooltipPanel));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_Dummy,
                    searchPixmapFile ("ui/frames_06.png"),
                    Rect(0,0,32,32));
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);

  // -------------------------------------------------------------------------
  image = new Image(kComponentID_Dummy,
                    searchPixmapFile ("ui/frames_01.png"),
                    Rect(0,0,736,16)); //w = 1280 - 32x17
  image->setAlpha (alpha);
  imageVector.push_back (image);
  addWidget (image);
}
