/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : TargetSelectionListener.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "TargetSelectionListener.h"
#include <mhgui/Image.h>
#include <mhgui/CGUtilities.h>
#include <animorph/Mesh.h>

#include <mhgui/Window.h>
#include <mhgui/Component.h>

#include "Global.h"
#include <stdio.h>
#include <assert.h>
#ifdef __APPLE__
  #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT     
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif
#include "ComponentID.h"
#include "TargetPanel.h"
//#include "Global.h"

using namespace Animorph;
using namespace std;

TargetSelectionListener::TargetSelectionListener()
    : AbstractListener()
{
}

TargetSelectionListener::~TargetSelectionListener()
{
}

bool TargetSelectionListener::mouseOver (const Point& inMousePos, Component *source)
{
  Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
  assert(imgSource); // Check if this is really an Image object?

  imgSource->setOverlayRectangle (Color (1,0,0,0.5));

  return false;
}

bool TargetSelectionListener::mouseOut (const Point& inMousePos, Component *source)
{
  Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
  assert(imgSource); // Check if this is really an Image object?

  imgSource->setOverlayRectangle (false);

  return false;
}

bool TargetSelectionListener::mouseDragged (const Point& inMousePos, Component *source)
{
  return true;
}

bool TargetSelectionListener::mousePressed(const Point& inMousePos, int button, Component *source)
{
  if (button == GLUT_LEFT_BUTTON)
  {
    Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
    assert(imgSource); // Check if this is really an Image object?
    imgSource->setOverlayRectangle(Color (1,1,1,0.5));
    
    return true;
  }      
  return false;
}

bool TargetSelectionListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{
  if(button == GLUT_LEFT_BUTTON)
  {
    Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
    assert(imgSource); // Check if this is really an Image object?

    imgSource->setOverlayRectangle(false);
    
    if(!imgSource->getAbsoluteRect().isHitBy(inMousePos))
      return false;
      
    string target;
      
    switch (imgSource->getID ())
    {
      // The Image ID's of the  BodyPanel (kComponentID_BodyPanel)
    case kComponentID_ImageBody_HeadParams:
      target = "head";
      break;
    case kComponentID_ImageBody_LeftShoulderParams:
      target = "l_shoulder";
      break;
    case kComponentID_ImageBody_RightShoulderParams:
      target = "r_shoulder";
      break;
    case kComponentID_ImageBody_NeckParams:
      target = "neck";
      break;
    case kComponentID_ImageBody_LeftUpperArmParams:
      target = "l_upper_arm";
      break;
    case kComponentID_ImageBody_RightUpperArmParams:
      target = "r_upper_arm";
      break;
    case kComponentID_ImageBody_LeftLowerArmParams:
      target = "l_lower_arm";
      break;
    case kComponentID_ImageBody_RightLowerArmParams:
      target = "r_lower_arm";
      break;
    case kComponentID_ImageBody_AbdomenParams:
      target = "abdomen";
      break;
    case kComponentID_ImageBody_TorsoParams:
      target = "torso";
      break;
    case kComponentID_ImageBody_TorsoParams2:
      target = "torso2";
      break;      
    case kComponentID_ImageBody_LeftHandParams:
      target = "l_hand";
      break;
    case kComponentID_ImageBody_RightHandParams:
      target = "r_hand";
      break;
    case kComponentID_ImageBody_PelvisParams:
      target = "pelvis";
      break;
    case kComponentID_ImageBody_LeftUpperLegParams:
      target = "l_upper_leg";
      break;
    case kComponentID_ImageBody_RightUpperLegParams:
      target = "r_upper_leg";
      break;
    case kComponentID_ImageBody_LeftLowerLegParams:
      target = "l_lower_leg";
      break;
    case kComponentID_ImageBody_RightLowerLegParams:
      target = "r_lower_leg";
      break;
    case kComponentID_ImageBody_LeftFootParams2:
      target = "l_foot2";
      break;
    case kComponentID_ImageBody_RightFootParams2:
      target = "r_foot2";
      break;
    case kComponentID_ImageBody_LeftFootParams:
      target = "l_foot";
      break;
    case kComponentID_ImageBody_RightFootParams:
      target = "r_foot";
      break;
      
      // The Image ID's of the  FacePanel (kComponentID_FacePanel)
    case kComponentID_FacePanel_RightEyeParams2:
      target = "r_eye2";
      break;
    case kComponentID_FacePanel_LeftEyeParams2:
      target = "l_eye2";
      break;      
    case kComponentID_FacePanel_BrowRidgeParams2:
      target = "forehead";
      break;
    case kComponentID_FacePanel_RightCheekParams:
      target = "r_cheek";
      break;      
    case kComponentID_FacePanel_NoseParams:
      target = "nose";
      break;
    case kComponentID_FacePanel_LeftCheekParams:
      target = "l_cheek";
      break;     
    case kComponentID_FacePanel_LeftEyeParams:
      target = "l_eye";
      break;
    case kComponentID_FacePanel_RightEyeParams:
      target = "r_eye";
      break;
    case kComponentID_FacePanel_LeftEarParams:
      target = "l_ear";
      break;
    case kComponentID_FacePanel_RightEarParams:
      target = "r_ear";
      break;
    case kComponentID_FacePanel_MouthParams:
      target = "mouth";
      break;
    case kComponentID_FacePanel_LeftEarParams2:
      target = "l_ear2";
      break;      
    case kComponentID_FacePanel_RightEarParams2:
      target = "r_ear2";
      break;
    case kComponentID_FacePanel_ChinJawParams:
      target = "chin_jaw";
      break;
    case kComponentID_FacePanel_MouthParams2:
      target = "mouth2";
      break;
    case kComponentID_FacePanel_MouthParams3:
      target = "mouth3";
      break;
    case kComponentID_FacePanel_BrowRidgeParams:
      target = "brow_ridge";
      break;
    case kComponentID_FacePanel_HeadParams2:
      target = "head2";
      break;
    case kComponentID_FacePanel_EyesParams:
      target = "eyes";
      break;
    case kComponentID_FacePanel_NoseParams2:
      target = "nose2";
      break;
    case kComponentID_FacePanel_EarsParams:
      target = "ears";
      break;
    case kComponentID_FacePanel_MuzzleParams:
      target = "muzzle";
      break;
    case kComponentID_FacePanel_ChinJawParams2:
      target = "chin_jaw2";
      break;
      
      // The Image ID's of the  TeethPanel (kComponentID_TeethPanel)
    case kComponentID_TeethPanel_TongueParams:
      target = "tongue";
      break;
    case kComponentID_TeethPanel_TeethParams:
      target = "teeth";
      break;
    case kComponentID_TeethPanel_UpperTeethRightParams:
      target = "upper_teeth_right";
      break;
    case kComponentID_TeethPanel_UpperTeethCenterParams:
      target = "upper_teeth_center";
      break;
    case kComponentID_TeethPanel_UpperTeethLeftParams:
      target = "upper_teeth_left";
      break;
    case kComponentID_TeethPanel_LowerTeethRightParams:
      target = "lower_teeth_right";
      break;
    case kComponentID_TeethPanel_LowerTeethCenterParams:
      target = "lower_teeth_center";
      break;
    case kComponentID_TeethPanel_LowerTeethLeftParams:
      target = "lower_teeth_left";
      break;

      // The Image ID's of the  HandsPanel (kComponentID_HandsPanel)
    case kComponentID_HandsPanel_RingfingerRightParams:
      target = "r_ringfinger";
      break;
    case kComponentID_HandsPanel_MiddlefingerRightParams:
      target = "r_middlefinger";
      break;
    case kComponentID_HandsPanel_MiddlefingerLeftParams:
      target = "l_middlefinger";
      break;
    case kComponentID_HandsPanel_RingfingerLeftParams:
      target = "l_ringfinger";
      break;
    case kComponentID_HandsPanel_ForefingerRightParams:
      target = "r_forefinger";
      break;
    case kComponentID_HandsPanel_ForefingerLeftParams:
      target = "l_forefinger";
      break;
    case kComponentID_HandsPanel_LittlefingerRightParams:
      target = "r_littlefinger";
      break;
    case kComponentID_HandsPanel_HandRightParams2:
      target = "r_hand2";
      break;
    case kComponentID_HandsPanel_PollexRightParams:
      target = "r_pollex";
      break;
    case kComponentID_HandsPanel_PollexLeftParams:
      target = "l_pollex";
      break;
    case kComponentID_HandsPanel_HandLeftParams2:
      target = "l_hand2";
      break;
    case kComponentID_HandsPanel_LittlefingerLeftParams:
      target = "l_littlefinger";
      break;

      // The Image ID's of the  FantasyBodyPanel (kComponentID_FantasyBodyPanel)
    case kComponentID_FantasyBody_HeadParams:
      target = "ns_head";
      break;
    case kComponentID_FantasyBody_LeftShoulderParams:
      target = "ns_l_shoulder";
      break;
    case kComponentID_FantasyBody_RightShoulderParams:
      target = "ns_r_shoulder";
      break;
    case kComponentID_FantasyBody_NeckParams:
      target = "ns_neck";
      break;
    case kComponentID_FantasyBody_LeftUpperArmParams:
      target = "ns_l_upper_arm";
      break;
    case kComponentID_FantasyBody_RightUpperArmParams:
      target = "ns_r_upper_arm";
      break;
    case kComponentID_FantasyBody_LeftLowerArmParams:
      target = "ns_l_lower_arm";
      break;
    case kComponentID_FantasyBody_RightLowerArmParams:
      target = "ns_r_lower_arm";
      break;
    case kComponentID_FantasyBody_AbdomenParams:
      target = "ns_abdomen";
      break;
    case kComponentID_FantasyBody_TorsoParams:
      target = "ns_torso";
      break;
    case kComponentID_FantasyBody_TorsoParams2:
      target = "ns_torso2";
      break;      
    case kComponentID_FantasyBody_LeftHandParams:
      target = "ns_l_hand";
      break;
    case kComponentID_FantasyBody_RightHandParams:
      target = "ns_r_hand";
      break;
    case kComponentID_FantasyBody_PelvisParams:
      target = "ns_pelvis";
      break;
    case kComponentID_FantasyBody_LeftUpperLegParams:
      target = "ns_l_upper_leg";
      break;
    case kComponentID_FantasyBody_RightUpperLegParams:
      target = "ns_r_upper_leg";
      break;
    case kComponentID_FantasyBody_LeftLowerLegParams:
      target = "ns_l_lower_leg";
      break;
    case kComponentID_FantasyBody_RightLowerLegParams:
      target = "ns_r_lower_leg";
      break;
    case kComponentID_FantasyBody_LeftFootParams2:
      target = "ns_l_foot2";
      break;
    case kComponentID_FantasyBody_RightFootParams2:
      target = "ns_r_foot2";
      break;
    case kComponentID_FantasyBody_LeftFootParams:
      target = "ns_l_foot";
      break;
    case kComponentID_FantasyBody_RightFootParams:
      target = "ns_r_foot";
      break;
      
      // The Image ID's of the  FantasyFacePanel (kComponentID_FacePanel)
    case kComponentID_FantasyFacePanel_RightEyeParams2:
      target = "ns_r_eye2";
      break;
    case kComponentID_FantasyFacePanel_LeftEyeParams2:
      target = "ns_l_eye2";
      break;      
    case kComponentID_FantasyFacePanel_BrowRidgeParams2:
      target = "ns_forehead";
      break;
    case kComponentID_FantasyFacePanel_RightCheekParams:
      target = "ns_r_cheek";
      break;      
    case kComponentID_FantasyFacePanel_NoseParams:
      target = "ns_nose";
      break;
    case kComponentID_FantasyFacePanel_LeftCheekParams:
      target = "ns_l_cheek";
      break;     
    case kComponentID_FantasyFacePanel_LeftEyeParams:
      target = "ns_l_eye";
      break;
    case kComponentID_FantasyFacePanel_RightEyeParams:
      target = "ns_r_eye";
      break;
    case kComponentID_FantasyFacePanel_LeftEarParams:
      target = "ns_l_ear";
      break;
    case kComponentID_FantasyFacePanel_RightEarParams:
      target = "ns_r_ear";
      break;
    case kComponentID_FantasyFacePanel_MouthParams:
      target = "ns_mouth";
      break;
    case kComponentID_FantasyFacePanel_LeftEarParams2:
      target = "ns_l_ear2";
      break;      
    case kComponentID_FantasyFacePanel_RightEarParams2:
      target = "ns_r_ear2";
      break;
    case kComponentID_FantasyFacePanel_ChinJawParams:
      target = "ns_chin_jaw";
      break;
    case kComponentID_FantasyFacePanel_MouthParams2:
      target = "ns_mouth2";
      break;
    case kComponentID_FantasyFacePanel_MouthParams3:
      target = "ns_mouth3";
      break;
    case kComponentID_FantasyFacePanel_BrowRidgeParams:
      target = "ns_brow_ridge";
      break;
    case kComponentID_FantasyFacePanel_HeadParams2:
      target = "ns_head2";
      break;
    case kComponentID_FantasyFacePanel_EyesParams:
      target = "ns_eyes";
      break;
    case kComponentID_FantasyFacePanel_NoseParams2:
      target = "ns_nose2";
      break;
    case kComponentID_FantasyFacePanel_EarsParams:
      target = "ns_ears";
      break;
    case kComponentID_FantasyFacePanel_MuzzleParams:
      target = "ns_muzzle";
      break;
    case kComponentID_FantasyFacePanel_ChinJawParams2:
      target = "ns_chin_jaw2";
      break;
      
      // The Image ID's of the  FantasyTeethPanel (kComponentID_FantasyTeethPanel)
    case kComponentID_FantasyTeethPanel_TongueParams:
      target = "ns_tongue";
      break;
    case kComponentID_FantasyTeethPanel_TeethParams:
      target = "ns_teeth";
      break;
    case kComponentID_FantasyTeethPanel_UpperTeethRightParams:
      target = "ns_upper_teeth_right";
      break;
    case kComponentID_FantasyTeethPanel_UpperTeethCenterParams:
      target = "ns_upper_teeth_center";
      break;
    case kComponentID_FantasyTeethPanel_UpperTeethLeftParams:
      target = "ns_upper_teeth_left";
      break;
    case kComponentID_FantasyTeethPanel_LowerTeethRightParams:
      target = "ns_lower_teeth_right";
      break;
    case kComponentID_FantasyTeethPanel_LowerTeethCenterParams:
      target = "ns_lower_teeth_center";
      break;
    case kComponentID_FantasyTeethPanel_LowerTeethLeftParams:
      target = "ns_lower_teeth_left";
      break;
      
      // The Image ID's of the  FantasyHandsPanel (kComponentID_FantasyHandsPanel)
    case kComponentID_FantasyHandsPanel_RingfingerRightParams:
      target = "ns_r_ringfinger";
      break;
    case kComponentID_FantasyHandsPanel_MiddlefingerRightParams:
      target = "ns_r_middlefinger";
      break;
    case kComponentID_FantasyHandsPanel_MiddlefingerLeftParams:
      target = "ns_l_middlefinger";
      break;
    case kComponentID_FantasyHandsPanel_RingfingerLeftParams:
      target = "ns_l_ringfinger";
      break;
    case kComponentID_FantasyHandsPanel_ForefingerRightParams:
      target = "ns_r_forefinger";
      break;
    case kComponentID_FantasyHandsPanel_ForefingerLeftParams:
      target = "ns_l_forefinger";
      break;      
    case kComponentID_FantasyHandsPanel_LittlefingerRightParams:
      target = "ns_r_littlefinger";
      break;
    case kComponentID_FantasyHandsPanel_HandRightParams2:
      target = "ns_r_hand2";
      break;
    case kComponentID_FantasyHandsPanel_PollexRightParams:
      target = "ns_r_pollex";
      break;
    case kComponentID_FantasyHandsPanel_PollexLeftParams:
      target = "ns_l_pollex";
      break;
    case kComponentID_FantasyHandsPanel_HandLeftParams2:
      target = "ns_l_hand2";
      break;
    case kComponentID_FantasyHandsPanel_LittlefingerLeftParams:
      target = "ns_l_littlefinger";
      break;            
    default:
      return false;
      break;
    }

    Window &mainWindow = Window::instance ();

    TargetPanel* targetPanel = dynamic_cast<TargetPanel*>(mainWindow.getPanel (kComponentID_TargetPanel));

    // Check if this Target Panel is not the current one?
    if ((targetPanel == NULL) || (targetPanel->getCategory() != target))
    {
        // No? The create it
        int x = mainWindow.getSize().getWidth() - 210;

        mainWindow.removePanel(targetPanel);
        delete targetPanel;

        targetPanel = new TargetPanel (target, Rect(x,40,210,550));

        mainWindow.addPanel (targetPanel);
        targetPanel->createWidgets ();
    }

    targetPanel->show_all();
    
    return true;
  }

  return false;
}

bool TargetSelectionListener::keyType (unsigned char key, Component *source)
{
  return false;
}
