/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : TargetPanel.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "TargetPanel.h"
#include "ComponentID.h"
#include "Global.h"

#include <mhgui/Window.h>
#include <mhgui/Rect.h>
#include <mhgui/ImageSlider.h>
#include <mhgui/Tooltip.h>
#include "Global.h"

using namespace std;
using namespace Animorph;

#include "ComponentID.h"

const static string kFilePrefixTarget (".target");
const static string kFilePrefixPNG    (".png");
const static unsigned int kMaxTargetsNumber = 65;

TargetPanel::TargetPanel (const string& category, const Rect& rect)
    : Panel (kComponentID_TargetPanel, rect),
    category (category)
{
  setRightAnchor (true);
  setRowSpacing (5);
  setColumnSpacing (3);
}

TargetPanel::~TargetPanel ()
{
  for_each (targetVector.begin (), targetVector.end (), deleteFunctor <TargetSlider*> ());
  delete close_image;
}

void TargetPanel::createWidgets ()
{
  Global &global = Global::instance ();
  Window &mainWindow = Window::instance ();

  Panel *tooltipPanel = mainWindow.getPanel (kComponentID_TooltipPanel);
  assert(tooltipPanel);

  Mesh *mesh = global.getMesh ();
  assert (mesh);

  TargetMap &targetmap = mesh->getTargetMapRef ();

  const Color c (1.0, 0.0, 0.0);
  const Point kTooltipPos (70, 12);

  BodySettings bodyset = mesh->getBodySettings ();

  TargetSlider *image_slider; 
  
  if (category == applied_target_list)
  {
    int targetSize;
    
    if(bodyset.size() > kMaxTargetsNumber)
    {
      targetSize = 24;
    }
    else
    {
      targetSize = 32;        
    }
    
    close_image = new Image(kComponentID_CloseTargetPanel,
                      searchPixmapFile ("ui/close_panel.png"),
                      Rect(0,0,targetSize,targetSize));  
    close_image->setListener(&imgListener);
    close_image->setTooltip(Tooltip("Close panel", kTooltipPos, c, tooltipPanel));  
    addWidget (close_image);    
    
    for (BodySettings::iterator bodyset_it = bodyset.begin ();
         bodyset_it != bodyset.end ();
         bodyset_it++)
    {
      const string& target_name((*bodyset_it).first); 
      float target_value = (*bodyset_it).second;
      string target_image (target_name);
      target_image.replace (target_image.length () - kFilePrefixTarget.length (),
                            kFilePrefixTarget.length (), kFilePrefixPNG);
    
      image_slider = new TargetSlider (kComponentID_TargetPanel_Target,
                                       searchPixmapFile ("tgimg/" + target_image),
                                       target_name,
                                       Rect(0,0,targetSize,targetSize + 10), 0.0, 1.0);

       image_slider->setSliderValue (target_value);
       image_slider->setListener(&imgSliderListener);
       image_slider->setTooltip(Tooltip(target_name, kTooltipPos, c, tooltipPanel));
       targetVector.push_back (image_slider);
       addWidget (image_slider);
    }
  }
  else
  {
    close_image = new Image(kComponentID_CloseTargetPanel,
                      searchPixmapFile ("ui/close_panel.png"),
                      Rect(0,0,32,32));
    close_image->setListener(&imgListener);
    close_image->setTooltip(Tooltip("Close panel", kTooltipPos, c, tooltipPanel));  
    addWidget (close_image);     
      
    for (TargetMap::const_iterator targetmap_it = targetmap.begin ();
        targetmap_it != targetmap.end ();
        targetmap_it++)
    {
      const string &target_name((*targetmap_it).first);  

      string::size_type loc = target_name.find ("/", 0 );
      if (loc == string::npos)
       continue;
      else
      {
       string sub = target_name.substr (0, loc);

       if (sub == category)
       {
         // remove ".target"
          string target_image (target_name);
          target_image.replace (target_image.length () - kFilePrefixTarget.length (),
                                kFilePrefixTarget.length (), kFilePrefixPNG);

          image_slider = new TargetSlider (kComponentID_TargetPanel_Target,
                                           searchPixmapFile ("tgimg/" + target_image),
                                           target_name,
                                           Rect(0,0,32,42), 0.0, 1.0);

          float target_value = bodyset[target_name];
          image_slider->setSliderValue (target_value);

          image_slider->setListener(&imgSliderListener);
          image_slider->setTooltip(Tooltip(target_name, kTooltipPos, c, tooltipPanel));
          targetVector.push_back (image_slider);
          addWidget (image_slider);
        }
      }
    }
  }
}
