#include <mhgui/ImageSlider.h>
#include <mhgui/CGUtilities.h>
#include "PoseTargetSliderListener.h"
#include "TargetSlider.h"
#include <animorph/Mesh.h>
#include "Global.h"
#include <stdio.h>
#include <assert.h>
#ifdef __APPLE__
  #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT     
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif

using namespace Animorph;
using namespace std;

const static float kPoseThreshold = 0.04;

PoseTargetSliderListener::PoseTargetSliderListener() 
: AbstractListener(),
  lastTargetName()
{
}

PoseTargetSliderListener::~PoseTargetSliderListener() 
{
}

bool PoseTargetSliderListener::mouseOver (const Point& inMousePos, Component *source)
{
  return false;
}

bool PoseTargetSliderListener::mouseOut (const Point& inMousePos, Component *source)
{
  return false;
}

bool PoseTargetSliderListener::mouseDragged (const Point& inMousePos, Component *source)
{
  TargetSlider *imgSliderSource = dynamic_cast<TargetSlider *>(source); // req. RTTI!
  assert(imgSliderSource); // Check if this is really a TargetSlider object?

  if(lastTargetName != imgSliderSource->getTargetName())
  {
    lastTargetName = imgSliderSource->getTargetName();
    lastTargetValue = imgSliderSource->getSliderValue ();                
  }
  else
  {
    float diffValue = lastTargetValue - imgSliderSource->getSliderValue ();
    if(diffValue < -kPoseThreshold || diffValue > kPoseThreshold)
    {
      lastTargetValue = imgSliderSource->getSliderValue ();
      
      Global &global = Global::instance ();
      Mesh *mesh = global.getMesh ();      
      mesh->setPose (imgSliderSource->getTargetName (), 
		 imgSliderSource->getSliderValue ());                    
    }
  }

  return true;
}

bool PoseTargetSliderListener::mousePressed(const Point& inMousePos, int button, Component *source)
{
  return false;
}

bool PoseTargetSliderListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{
  TargetSlider *imgSliderSource = dynamic_cast<TargetSlider *>(source); // req. RTTI!
  assert(imgSliderSource); // Check if this is really a TargetSlider object?
       
  Global &global = Global::instance ();
  Mesh *mesh = global.getMesh ();
  
  mesh->setPose (imgSliderSource->getTargetName (), 
		 imgSliderSource->getSliderValue ());  
  
  mesh->calcNormals ();
  return false;
}

bool PoseTargetSliderListener::keyType (unsigned char key, Component *source)
{
  return false;
}
