/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : FantasyHandsPanel.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "FantasyHandsPanel.h"
#include "ImageListener.h"
#include "ComponentID.h"

#include <mhgui/Window.h>
#include <mhgui/Rect.h>
#include <mhgui/Tooltip.h>
//#include "Global.h"

using namespace std;
using namespace Animorph;

FantasyHandsPanel::FantasyHandsPanel ()
    : Panel (kComponentID_FantasyHandsPanel, Rect(0,400,192,96))
{
}

FantasyHandsPanel::~FantasyHandsPanel ()
{
  for_each (imageVector.begin (), imageVector.end (), deleteFunctor <Image*> ());
}

void FantasyHandsPanel::createWidgets ()
{
  Window &mainWindow = Window::instance ();

  Panel *tooltipPanel = mainWindow.getPanel(kComponentID_TooltipPanel);
  assert(tooltipPanel);

  const Color color_red (1.0, 0.0, 0.0);
  const Point kTooltipPos(70, 12);
  const float alpha = 0.8;
  Image *body;

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_RingfingerRightParams,
                   searchPixmapFile ("ui/ns_hands_01.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Ringfinger parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_MiddlefingerRightParams,
                   searchPixmapFile ("ui/ns_hands_02.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Middlefinger parameters", kTooltipPos, color_red, tooltipPanel));                   
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_ForefingerRightParams,
                   searchPixmapFile ("ui/ns_hands_03.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Forefinger parameters", kTooltipPos, color_red, tooltipPanel));                   
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_ForefingerLeftParams,
                   searchPixmapFile ("ui/ns_hands_04.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Forefinger parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_MiddlefingerLeftParams,
                   searchPixmapFile ("ui/ns_hands_05.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Middlefinger parameters", kTooltipPos, color_red, tooltipPanel));                   
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_RingfingerLeftParams,
                   searchPixmapFile ("ui/ns_hands_06.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Ringfinger parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_LittlefingerRightParams,
                   searchPixmapFile ("ui/ns_hands_07.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Littlefinger parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_hands_08.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_hands_09.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_hands_10.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Forefinger parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);  

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_hands_11.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_LittlefingerLeftParams,
                   searchPixmapFile ("ui/ns_hands_12.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Littlefinger parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);  
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_hands_13.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_HandRightParams2,
                   searchPixmapFile ("ui/ns_hands_14.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Hand parameters 2", kTooltipPos, color_red, tooltipPanel));                   
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_PollexRightParams,
                   searchPixmapFile ("ui/ns_hands_15.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Pollex parameters", kTooltipPos, color_red, tooltipPanel));                   
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_PollexLeftParams,
                   searchPixmapFile ("ui/ns_hands_16.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Pollex parameters", kTooltipPos, color_red, tooltipPanel));                   
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);  
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyHandsPanel_HandLeftParams2,
                   searchPixmapFile ("ui/ns_hands_17.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Hand parameters 2", kTooltipPos, color_red, tooltipPanel));                   
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_hands_18.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);          
}
