/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : TextPanel.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef DIALOGPANEL_H
#define DIALOGPANEL_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <mhgui/TextEntry.h>
#include <mhgui/Panel.h>
#include <mhgui/Label.h>
#include "DialogListener.h"
#include "util.h"

class DialogPanel : public Panel
{
public:
  DialogPanel (uint32_t id);
  virtual ~DialogPanel ();

  void createWidgets ();

  virtual void calcWidgetPosition ();
  uint32_t getSourceID () {return id;}

  void setTitleText (const string& t);
  string getTitleText () {return title.getText ();}

  void setErrorText (const string& t);
  string getErrorText () {return error.getText ();}

  void setEntryText (const string& t);
  string getEntryText () {return text.getText ();}

private:
  // intentionally not implemented
  DialogPanel             (const DialogPanel&);
  DialogPanel& operator = (const DialogPanel&);

  TextEntry text;
  Label title;
  Label error;
  DialogTextEntryListener dialogTextEntryListener;
  DialogPanelListener dialogPanelListener;
  uint32_t id;
};

#endif // DIALOGPANEL_H
