/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : TextPanel.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include <animorph/util.h>
#include <mhgui/Window.h>
#include <mhgui/Rect.h>
#include <mhgui/Tooltip.h>
#include "DialogPanel.h"
#include "ImageListener.h"
#include "ComponentID.h"

using namespace std;
using namespace Animorph;

DialogPanel::DialogPanel (uint32_t id)
    : Panel (kComponentID_TextPanel, Rect(200,200,300,100)),
    text (kComponentID_Dummy, Rect(0,0,300,21)),
    title (kComponentID_Dummy, Rect (0,0,0,0)),
    error (kComponentID_Dummy, Rect (0,0,0,0)),
    id (id)
{
  setListener (&dialogPanelListener);
  setActive(true);
}

DialogPanel::~DialogPanel ()
{
}

void DialogPanel::createWidgets ()
{
  setBackgroundColor (Color (0.5,0.5,0.5,0.9));
  setAlignment (Panel::FREE);
  setMaximize (true);

  title.setFont (GLUT_BITMAP_TIMES_ROMAN_24);
  title.setAutoSize (true);
  addWidget (&title);

  text.setText (getHomeDir());
  text.setBorderColor (Color (1,0.56,0,1));
  text.setListener (&dialogTextEntryListener);
  text.setActive(true);
  addWidget (&text);

  error.setFont (GLUT_BITMAP_HELVETICA_12);
  error.setTextColor (Color (1,0,0,1));
  error.setAutoSize (true);
  addWidget (&error);
}

void DialogPanel::calcWidgetPosition ()
{
  int panelWidth = getSize().getWidth();
  int panelHeight = getSize().getHeight();

  title.setPosition (Point (panelWidth/2 - title.getSize().getWidth()/2,
                            panelHeight/3));

  text.setPosition (Point (panelWidth/2 - text.getSize().getWidth()/2,
                           panelHeight/3 + 50));

  error.setPosition (Point (panelWidth/2 - error.getSize().getWidth()/2,
                            panelHeight/3 + 100));


  // calc calc function from Panel parent
  Panel::calcWidgetPosition ();
}

void DialogPanel::setTitleText (const string& t)
{
  title.setText (t);
  calcWidgetPosition ();
}

void DialogPanel::setErrorText (const string& t)
{
  error.setText (t);
  calcWidgetPosition ();
}

void DialogPanel::setEntryText (const string& t)
{
  text.setText (t);
  calcWidgetPosition ();
}
