/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : DialogListner.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include <animorph/ObjExporter.h>
#include <animorph/BodySettings.h>
#include <mhgui/TextEntry.h>
#include <mhgui/CGUtilities.h>
#include "DialogListener.h"
#include "DialogPanel.h"
#include "ComponentID.h"
#include "Global.h"
#include <iostream>
#include <assert.h>
#ifdef __APPLE__
  #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT     
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif

using namespace std;

DialogPanelListener::DialogPanelListener()
    : AbstractListener()
{
}

DialogPanelListener::~DialogPanelListener()
{
}

bool DialogPanelListener::mouseOver (const Point& inMousePos, Component *source)
{
  return true;
}

bool DialogPanelListener::mouseOut (const Point& inMousePos, Component *source)
{
  return true;
}

bool DialogPanelListener::mouseDragged (const Point& inMousePos, Component *source)
{
  return true;
}

bool DialogPanelListener::mousePressed (const Point& inMousePos, int button, Component *source)
{
  return true;
}

bool DialogPanelListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{
  return true;
}

bool DialogPanelListener::keyType (unsigned char key, Component *source)
{
  DialogPanel *dpanelSource = dynamic_cast<DialogPanel *>(source); // req. RTTI!
  assert(dpanelSource);

  switch(key)
  {
  case 27:
    delete dpanelSource;

    return true;
    break;
  }

  return true;
}

////// TextEntry listener
/////////////////////////

DialogTextEntryListener::DialogTextEntryListener()
    : AbstractListener()
{
}

DialogTextEntryListener::~DialogTextEntryListener()
{
}

bool DialogTextEntryListener::mouseOver (const Point& inMousePos, Component *source)
{
  return false;
}

bool DialogTextEntryListener::mouseOut (const Point& inMousePos, Component *source)
{
  return false;
}

bool DialogTextEntryListener::mouseDragged (const Point& inMousePos, Component *source)
{
  return true;
}

bool DialogTextEntryListener::mousePressed (const Point& inMousePos, int button, Component *source)
{
  return true;
}

bool DialogTextEntryListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{
  return true;
}

bool DialogTextEntryListener::keyType (unsigned char key, Component *source)
{
  TextEntry *txtSource = dynamic_cast<TextEntry *>(source); // req. RTTI!
  assert(txtSource);

  switch(key)
  {
  case 27:
    delete txtSource->getParentPanel ();
    break;

  case '\r':
    selectSource (txtSource);

    return true;
    break;
  }

  return true;
}

void DialogTextEntryListener::selectSource (TextEntry *txtSource)
{
  DialogPanel *dialogPanel = dynamic_cast<DialogPanel *>(txtSource->getParentPanel ());

  switch (dialogPanel->getSourceID ())
  {
  case kComponentID_ImageToolbarPanel_LoadBodysettings:
    loadBS (txtSource);
    break;
  case kComponentID_ImageToolbarPanel_SaveBodysettings:
    saveBS (txtSource);
    break;
  case kComponentID_ImageToolbarPanel_ExportWavefrontObj:
    exportOBJ (txtSource);
    break;

  default:
    cerr << "Unknown widget handler!" << endl;
  }
}

void DialogTextEntryListener::exportOBJ (TextEntry *txtSource)
{
  DialogPanel *dialogPanel = dynamic_cast<DialogPanel *>(txtSource->getParentPanel ());

  Global &global = Global::instance ();
  Mesh *mesh = global.getMesh ();
  assert (mesh);

  ObjExporter obj_export (*mesh);
  bool state = obj_export.exportFile (txtSource->getText ());

  if (state)
    delete txtSource->getParentPanel ();
  else
    dialogPanel->setErrorText ("Error: Couldn't save file. Please try again or press ESC!");
}

void DialogTextEntryListener::saveBS (TextEntry *txtSource)
{
  DialogPanel *dialogPanel = dynamic_cast<DialogPanel *>(txtSource->getParentPanel ());

  Global &global = Global::instance ();
  Mesh *mesh = global.getMesh ();
  assert (mesh);

  BodySettings bodyset = mesh->getBodySettings ();
  bool state = bodyset.save (txtSource->getText ());

  if (state)
    delete txtSource->getParentPanel ();
  else
    dialogPanel->setErrorText ("Error: Couldn't save file. Please try again or press ESC!");
}

void DialogTextEntryListener::loadBS (TextEntry *txtSource)
{
  DialogPanel *dialogPanel = dynamic_cast<DialogPanel *>(txtSource->getParentPanel ());

  Global &global = Global::instance ();
  Mesh *mesh = global.getMesh ();
  assert (mesh);

  BodySettings bodyset;
  bool state = bodyset.load (txtSource->getText ());
  mesh->doMorph (bodyset);

  if (state)
    delete txtSource->getParentPanel ();
  else
    dialogPanel->setErrorText ("Error: Couldn't save file. Please try again or press ESC!");
}
