#include <mhgui/ImageSlider.h>
#include <mhgui/CGUtilities.h>
#include "BsSliderListener.h"
#include "TargetSlider.h"
#include <animorph/Mesh.h>
#include "Global.h"
#include <stdio.h>
#include <assert.h>
#include "ComponentID.h"
#include "CharacterSettingPanel.h"
#include "BsPanel.h"
#ifdef __APPLE__
  #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif

using namespace Animorph;
using namespace std;

const static float kPoseThreshold = 0.04;

BsSliderListener::BsSliderListener() 
: AbstractListener(),
  lastTargetName()
{
}

BsSliderListener::~BsSliderListener() 
{
}

bool BsSliderListener::mouseOver (const Point& inMousePos, Component *source)
{
  return false;
}

bool BsSliderListener::mouseOut (const Point& inMousePos, Component *source)
{
  return false;
}

bool BsSliderListener::mouseDragged (const Point& inMousePos, Component *source)
{
  TargetSlider *imgSliderSource = dynamic_cast<TargetSlider *>(source); // req. RTTI!
  assert(imgSliderSource); // Check if this is really a TargetSlider object?

  Window &mainWindow = Window::instance ();

  bool isTargetPanel = (imgSliderSource->getParentPanel()->getID() == kComponentID_TargetPanel);
  
  if(!isTargetPanel)
  {
    Panel *p = mainWindow.getPanel (kComponentID_TargetPanel);
    if(p != NULL) 
         delete p;
  }

  if(lastTargetName != imgSliderSource->getTargetName()) 
  {
    lastTargetName = imgSliderSource->getTargetName();
    lastTargetValue = imgSliderSource->getSliderValue ();
  }
  else
  {
    float diffValue = lastTargetValue - imgSliderSource->getSliderValue ();
    if(diffValue < -kPoseThreshold || diffValue > kPoseThreshold)
    {        
      Global &global = Global::instance ();
      Mesh *mesh = global.getMesh ();
      CharactersMap &charactersmap = mesh->getCharactersMapRef ();

      mesh->doMorph (charactersmap[imgSliderSource->getTargetName ()], 
                     imgSliderSource->getSliderValue (), false);               
    }
  }

  /* TODO:
   * It's a little slow to calc normals in realtime while morphing.
   * A better way is to calc it once after a drag operation ends. This
   * needs some changes in listener implementation.
   *
   * Another solution is to speed up normals calculation in animorph.
   * I've some good ideas how to do this...
   */
  
  return true;
}

bool BsSliderListener::mousePressed(const Point& inMousePos, int button, Component *source)
{       
  return false;
}

bool BsSliderListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{

  TargetSlider *imgSliderSource = dynamic_cast<TargetSlider *>(source); // req. RTTI!
  assert(imgSliderSource); // Check if this is really a TargetSlider object?
       
  Global &global = Global::instance ();
  Mesh *mesh = global.getMesh ();

  CharactersMap &charactersmap = mesh->getCharactersMapRef ();
  mesh->doMorph (charactersmap[imgSliderSource->getTargetName ()], 
                 imgSliderSource->getSliderValue (), false);  
                 
  mesh->calcNormals ();
  return false;
}

bool BsSliderListener::keyType (unsigned char key, Component *source)
{
  return false;
}
