/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-pi-mailbox.h"

#include "mn-pi-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 40 "mn-pi-mailbox.gob"

#include "config.h"
#include <gnome.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-util.h"
#include "mn-stock.h"

static GHashTable *password_database;
G_LOCK_DEFINE_STATIC(password_database);

struct _MNClientSessionPrivate
{
  MN_PI_MAILBOX_SESSION_PRIVATE;
};

#line 43 "mn-pi-mailbox.c"
static const GEnumValue _mn_pi_mailbox_connection_type_values[] = {
	{ MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL, (char *)"MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL", (char *)"normal" },
	{ MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL, (char *)"MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL", (char *)"inband-ssl" },
	{ MN_PI_MAILBOX_CONNECTION_TYPE_SSL, (char *)"MN_PI_MAILBOX_CONNECTION_TYPE_SSL", (char *)"ssl" },
	{ 0, NULL, NULL }
};

GType
mn_pi_mailbox_connection_type_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNPIMailboxConnectionType", _mn_pi_mailbox_connection_type_values);
	return type;
}

/* self casting macros */
#define SELF(x) MN_PI_MAILBOX(x)
#define SELF_CONST(x) MN_PI_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_PI_MAILBOX(x)
#define TYPE_SELF MN_TYPE_PI_MAILBOX
#define SELF_CLASS(x) MN_PI_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_PI_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNPIMailbox Self;
typedef MNPIMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_pi_mailbox_class_init (MNPIMailboxClass * class) G_GNUC_UNUSED;
static void mn_pi_mailbox_init (MNPIMailbox * self) G_GNUC_UNUSED;
static void ___3_mn_pi_mailbox_removed (MNMailbox * mailbox) G_GNUC_UNUSED;
static void ___4_mn_pi_mailbox_seal (MNMailbox * mailbox) G_GNUC_UNUSED;
static void ___5_mn_pi_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox) G_GNUC_UNUSED;
static gboolean mn_pi_mailbox_credentials_prompt (MNPIMailbox * self, char ** username, char ** password, const char * format, ...) G_GNUC_UNUSED;
static char * mn_pi_mailbox_build_auth_id (MNPIMailbox * self, const char * username) G_GNUC_UNUSED;
static char * mn_pi_mailbox_get_password (MNPIMailbox * self, const char * username) G_GNUC_UNUSED;
static void mn_pi_mailbox_set_password (MNPIMailbox * self, const char * username, const char * password) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_CONNECTION_TYPE,
	PROP_AUTHMECH,
	PROP_HOSTNAME,
	PROP_PORT
};

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_split_uri mn_pi_mailbox_split_uri
#define self_split_uri_auth mn_pi_mailbox_split_uri_auth
#define self_split_uri_hostport mn_pi_mailbox_split_uri_hostport
#define self_auth_failed mn_pi_mailbox_auth_failed
#define self_fill_credentials mn_pi_mailbox_fill_credentials
#define self_credentials_prompt mn_pi_mailbox_credentials_prompt
#define self_build_auth_id mn_pi_mailbox_build_auth_id
#define self_get_password mn_pi_mailbox_get_password
#define self_set_password mn_pi_mailbox_set_password
#define self_session_private_init mn_pi_mailbox_session_private_init
#define self_sasl_get_credentials_cb mn_pi_mailbox_sasl_get_credentials_cb
#define self_notice_cb mn_pi_mailbox_notice_cb
#define self_warning_cb mn_pi_mailbox_warning_cb
GType
mn_pi_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNPIMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_pi_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNPIMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_pi_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNPIMailbox", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNPIMailbox *)g_object_new(mn_pi_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNPIMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNPIMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNPIMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNPIMailbox *)g_object_new_valist (mn_pi_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::finalize"
	MNPIMailbox *self G_GNUC_UNUSED = MN_PI_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 74 "mn-pi-mailbox.gob"
	if(self->authmech) { g_free ((gpointer) self->authmech); self->authmech = NULL; }
#line 164 "mn-pi-mailbox.c"
#line 78 "mn-pi-mailbox.gob"
	if(self->hostname) { g_free ((gpointer) self->hostname); self->hostname = NULL; }
#line 167 "mn-pi-mailbox.c"
#line 89 "mn-pi-mailbox.gob"
	if(self->runtime_username) { g_free ((gpointer) self->runtime_username); self->runtime_username = NULL; }
#line 170 "mn-pi-mailbox.c"
#line 90 "mn-pi-mailbox.gob"
	if(self->runtime_password) { g_free ((gpointer) self->runtime_password); self->runtime_password = NULL; }
#line 173 "mn-pi-mailbox.c"
}
#undef __GOB_FUNCTION__

#line 97 "mn-pi-mailbox.gob"
static void 
mn_pi_mailbox_class_init (MNPIMailboxClass * class G_GNUC_UNUSED)
#line 180 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNPIMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 113 "mn-pi-mailbox.gob"
	mn_mailbox_class->removed = ___3_mn_pi_mailbox_removed;
#line 124 "mn-pi-mailbox.gob"
	mn_mailbox_class->seal = ___4_mn_pi_mailbox_seal;
#line 140 "mn-pi-mailbox.gob"
	mn_authenticated_mailbox_class->authenticated_check = ___5_mn_pi_mailbox_authenticated_check;
#line 197 "mn-pi-mailbox.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_enum
		("connection_type" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MN_TYPE_PI_MAILBOX_CONNECTION_TYPE /* enum_type */,
		 MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_CONNECTION_TYPE,
		param_spec);
	param_spec = g_param_spec_string
		("authmech" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_AUTHMECH,
		param_spec);
	param_spec = g_param_spec_string
		("hostname" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_REQUIRED | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_HOSTNAME,
		param_spec);
	param_spec = g_param_spec_int
		("port" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 65535 /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_PORT,
		param_spec);
    }
 {
#line 98 "mn-pi-mailbox.gob"

    password_database = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);

    /*
     * 5 minutes is a good default check delay for remote POP3/IMAP
     * mailboxes.
     */
    MN_MAILBOX_CLASS(class)->default_check_delay = 60 * 5;
  
#line 255 "mn-pi-mailbox.c"
 }
}
#undef __GOB_FUNCTION__
#line 108 "mn-pi-mailbox.gob"
static void 
mn_pi_mailbox_init (MNPIMailbox * self G_GNUC_UNUSED)
#line 262 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_PI_MAILBOX,MNPIMailboxPrivate);
 {
#line 109 "mn-pi-mailbox.gob"

    mn_mailbox_set_stock_id(MN_MAILBOX(self), MN_STOCK_REMOTE);
  
#line 271 "mn-pi-mailbox.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:PI:Mailbox::set_property"
{
	MNPIMailbox *self G_GNUC_UNUSED;

	self = MN_PI_MAILBOX (object);

	switch (property_id) {
	case PROP_CONNECTION_TYPE:
		{
#line 69 "mn-pi-mailbox.gob"
self->connection_type = g_value_get_enum (VAL);
#line 292 "mn-pi-mailbox.c"
		}
		break;
	case PROP_AUTHMECH:
		{
#line 75 "mn-pi-mailbox.gob"
{ char *old = self->authmech; self->authmech = g_value_dup_string (VAL); g_free (old); }
#line 299 "mn-pi-mailbox.c"
		}
		break;
	case PROP_HOSTNAME:
		{
#line 79 "mn-pi-mailbox.gob"
{ char *old = self->hostname; self->hostname = g_value_dup_string (VAL); g_free (old); }
#line 306 "mn-pi-mailbox.c"
		}
		break;
	case PROP_PORT:
		{
#line 82 "mn-pi-mailbox.gob"
self->port = g_value_get_int (VAL);
#line 313 "mn-pi-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:PI:Mailbox::get_property"
{
	MNPIMailbox *self G_GNUC_UNUSED;

	self = MN_PI_MAILBOX (object);

	switch (property_id) {
	case PROP_CONNECTION_TYPE:
		{
#line 69 "mn-pi-mailbox.gob"
g_value_set_enum (VAL, self->connection_type);
#line 344 "mn-pi-mailbox.c"
		}
		break;
	case PROP_AUTHMECH:
		{
#line 75 "mn-pi-mailbox.gob"
g_value_set_string (VAL, self->authmech);
#line 351 "mn-pi-mailbox.c"
		}
		break;
	case PROP_HOSTNAME:
		{
#line 79 "mn-pi-mailbox.gob"
g_value_set_string (VAL, self->hostname);
#line 358 "mn-pi-mailbox.c"
		}
		break;
	case PROP_PORT:
		{
#line 82 "mn-pi-mailbox.gob"
g_value_set_int (VAL, self->port);
#line 365 "mn-pi-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 113 "mn-pi-mailbox.gob"
static void 
___3_mn_pi_mailbox_removed (MNMailbox * mailbox G_GNUC_UNUSED)
#line 385 "mn-pi-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->removed) \
		(* MN_MAILBOX_CLASS(parent_class)->removed)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::removed"
{
#line 115 "mn-pi-mailbox.gob"
	
    Self *self = SELF(mailbox);

    if (selfp->auth_dialog)
      gtk_dialog_response(GTK_DIALOG(selfp->auth_dialog), GTK_RESPONSE_CANCEL);

    PARENT_HANDLER(mailbox);
  }}
#line 401 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 124 "mn-pi-mailbox.gob"
static void 
___4_mn_pi_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 408 "mn-pi-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::seal"
{
#line 126 "mn-pi-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    /* do not save default port to mailboxes.xml */
    if (self->port == SELF_GET_CLASS(self)->default_ports[self->connection_type])
      self->port = 0;

    self->runtime_port = self->port == 0
      ? SELF_GET_CLASS(self)->default_ports[self->connection_type]
      : self->port;
  }}
#line 429 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 140 "mn-pi-mailbox.gob"
static void 
___5_mn_pi_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox G_GNUC_UNUSED)
#line 436 "mn-pi-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check) \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::authenticated_check"
{
#line 142 "mn-pi-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

#ifndef WITH_SSL
    if (self->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL
	|| self->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_SSL)
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(mailbox), _("SSL/TLS support has not been compiled in"));
	mn_mailbox_set_poll(MN_MAILBOX(mailbox), FALSE); /* disable the mailbox */

	gdk_flush();
	GDK_THREADS_LEAVE();
      }
#endif

    self->auth_prompted = FALSE;
    selfp->auth_failed = FALSE;
  }}
#line 466 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 165 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_split_uri (const char * uri, int maxlen, char * scheme, char * auth, char * location, gboolean * has_auth)
#line 473 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::split_uri"
#line 165 "mn-pi-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 165 "mn-pi-mailbox.gob"
	g_return_val_if_fail (scheme != NULL, (gboolean )0);
#line 165 "mn-pi-mailbox.gob"
	g_return_val_if_fail (auth != NULL, (gboolean )0);
#line 165 "mn-pi-mailbox.gob"
	g_return_val_if_fail (location != NULL, (gboolean )0);
#line 165 "mn-pi-mailbox.gob"
	g_return_val_if_fail (has_auth != NULL, (gboolean )0);
#line 486 "mn-pi-mailbox.c"
{
#line 172 "mn-pi-mailbox.gob"
	
    char *pat;
    int n;

    pat = g_strdup_printf("%%%i[^:]://%%%i[^@]@%%%is", maxlen, maxlen, maxlen);
    n = sscanf(uri, pat, scheme, auth, location);
    g_free(pat);

    if (n >= 2)
      {
	*has_auth = n == 3;

	if (! *has_auth)
	  strcpy(location, auth);

	return TRUE;
      }
    else
      return FALSE;
  }}
#line 509 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 193 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_split_uri_auth (const char * auth, int maxlen, char * username, char * authmech, gboolean * has_username, gboolean * has_authmech)
#line 515 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::split_uri_auth"
#line 193 "mn-pi-mailbox.gob"
	g_return_val_if_fail (auth != NULL, (gboolean )0);
#line 193 "mn-pi-mailbox.gob"
	g_return_val_if_fail (username != NULL, (gboolean )0);
#line 193 "mn-pi-mailbox.gob"
	g_return_val_if_fail (authmech != NULL, (gboolean )0);
#line 193 "mn-pi-mailbox.gob"
	g_return_val_if_fail (has_username != NULL, (gboolean )0);
#line 193 "mn-pi-mailbox.gob"
	g_return_val_if_fail (has_authmech != NULL, (gboolean )0);
#line 528 "mn-pi-mailbox.c"
{
#line 200 "mn-pi-mailbox.gob"
	
    char *pat;
    int n;

    pat = g_strdup_printf("%%%i[^;];AUTH=%%%is", maxlen, maxlen);
    n = sscanf(auth, pat, username, authmech);
    g_free(pat);

    *has_username = FALSE;
    *has_authmech = FALSE;

    if (n >= 1)
      {
	*has_username = TRUE;

	if (n == 2)
	  *has_authmech = TRUE;
      }
    else
      {
	pat = g_strdup_printf(";AUTH=%%%is", maxlen);
	n = sscanf(auth, pat, authmech);
	g_free(pat);

	if (n < 1)
	  return FALSE;

	*has_authmech = TRUE;
      }

    return TRUE;
  }}
#line 563 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 233 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_split_uri_hostport (const char * hostport, int maxlen, char * hostname, int * port)
#line 569 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::split_uri_hostport"
#line 233 "mn-pi-mailbox.gob"
	g_return_if_fail (hostport != NULL);
#line 233 "mn-pi-mailbox.gob"
	g_return_if_fail (hostname != NULL);
#line 233 "mn-pi-mailbox.gob"
	g_return_if_fail (port != NULL);
#line 578 "mn-pi-mailbox.c"
{
#line 238 "mn-pi-mailbox.gob"
	
    char *pat;
    int n;

    /* split host:port part in 2 subparts: host and port */

    pat = g_strdup_printf("[%%%i[^]]]:%%u", maxlen);
    n = sscanf(hostport, pat, hostname, port);
    g_free(pat);

    if (n < 1)
      {
	pat = g_strdup_printf("%%%i[^:]:%%u", maxlen);
	n = sscanf(hostport, pat, hostname, port);
	g_free(pat);
      }

    g_assert(n >= 1);

    if (n < 2)
      *port = 0;
  }}
#line 603 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 261 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_auth_failed (MNPIMailbox * self)
#line 609 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::auth_failed"
#line 261 "mn-pi-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 261 "mn-pi-mailbox.gob"
	g_return_if_fail (MN_IS_PI_MAILBOX (self));
#line 616 "mn-pi-mailbox.c"
{
#line 263 "mn-pi-mailbox.gob"
	
    MNAuthenticatedMailbox *auth_mailbox = MN_AUTHENTICATED_MAILBOX(self);

    if (! auth_mailbox->password)
      {
	g_free(self->runtime_password);
	self->runtime_password = NULL;

	if (self->runtime_username)
	  self_set_password(self, self->runtime_username, NULL);
      }

    if (! auth_mailbox->username)
      {
	g_free(self->runtime_username);
	self->runtime_username = NULL;
      }

    selfp->auth_failed = TRUE;
  }}
#line 639 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 284 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_fill_credentials (MNPIMailbox * self, gboolean need_username, gboolean need_password)
#line 645 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::fill_credentials"
#line 284 "mn-pi-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 284 "mn-pi-mailbox.gob"
	g_return_val_if_fail (MN_IS_PI_MAILBOX (self), (gboolean )0);
#line 652 "mn-pi-mailbox.c"
{
#line 286 "mn-pi-mailbox.gob"
	
    MNAuthenticatedMailbox *auth_mailbox = MN_AUTHENTICATED_MAILBOX(self);

    g_return_val_if_fail(need_username || need_password, FALSE);

    self->auth_cancelled = FALSE;

    if (! self->runtime_username)
      self->runtime_username = g_strdup(auth_mailbox->username);
    if (! self->runtime_password)
      self->runtime_password = g_strdup(auth_mailbox->password);

    if (self->runtime_username && ! self->runtime_password && need_password)
      self->runtime_password = self_get_password(self, self->runtime_username);

    if (self->runtime_username)
      need_username = FALSE;
    if (self->runtime_password)
      need_password = FALSE;

    if (need_username || need_password)
      {
	char *username;
	char *password;

	GDK_THREADS_ENTER();

	self->auth_prompted = TRUE;

	if (self_credentials_prompt(self,
				    need_username ? &username : NULL,
				    need_password ? &password : NULL,
				    selfp->auth_failed
				    ? _("Mail Notification was unable to log into %s mailbox %s, possibly because the credentials you have entered are invalid.\n\nPlease re-enter your credentials.")
				    : _("Enter your credentials for %s mailbox %s."),
				    MN_MAILBOX(self)->format,
				    MN_MAILBOX(self)->runtime_name))
	  {
	    if (need_username)
	      self->runtime_username = username;
	    if (need_password)
	      self->runtime_password = password;
	  }
	else
	  self->auth_cancelled = TRUE;

	gdk_flush();
	GDK_THREADS_LEAVE();
      }

    if (self->runtime_username && self->runtime_password)
      self_set_password(self, self->runtime_username, self->runtime_password);

    return ! self->auth_cancelled;
  }}
#line 710 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 342 "mn-pi-mailbox.gob"
static gboolean 
mn_pi_mailbox_credentials_prompt (MNPIMailbox * self, char ** username, char ** password, const char * format, ...)
#line 716 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::credentials_prompt"
#line 342 "mn-pi-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 342 "mn-pi-mailbox.gob"
	g_return_val_if_fail (MN_IS_PI_MAILBOX (self), (gboolean )0);
#line 342 "mn-pi-mailbox.gob"
	g_return_val_if_fail (format != NULL, (gboolean )0);
#line 725 "mn-pi-mailbox.c"
{
#line 348 "mn-pi-mailbox.gob"
	
    va_list args;
    char *message;
    gboolean ok;

    g_return_val_if_fail(selfp->auth_dialog == NULL, FALSE);
    g_return_val_if_fail(username != NULL || password != NULL, FALSE);

    va_start(args, format);
    message = g_strdup_vprintf(format, args);
    va_end(args);

    /* keep the title in sync with gnome-authentication-manager */

    /* translators: header capitalization */
    selfp->auth_dialog = gnome_password_dialog_new(_("Authentication Required"),
						   message,
						   self->runtime_username,
						   self->runtime_password,
						   FALSE);
    g_free(message);

    eel_add_weak_pointer(&selfp->auth_dialog);

    gnome_password_dialog_set_show_userpass_buttons(GNOME_PASSWORD_DIALOG(selfp->auth_dialog), FALSE);
    gnome_password_dialog_set_readonly_username(GNOME_PASSWORD_DIALOG(selfp->auth_dialog), username == NULL);
    gnome_password_dialog_set_show_password(GNOME_PASSWORD_DIALOG(selfp->auth_dialog), password != NULL);

    ok = gnome_password_dialog_run_and_block(GNOME_PASSWORD_DIALOG(selfp->auth_dialog));
    if (ok)
      {
	if (username)
	  *username = gnome_password_dialog_get_username(GNOME_PASSWORD_DIALOG(selfp->auth_dialog));
	if (password)
	  *password = gnome_password_dialog_get_password(GNOME_PASSWORD_DIALOG(selfp->auth_dialog));
      }

    gtk_widget_destroy(selfp->auth_dialog);

    return ok;
  }}
#line 769 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 390 "mn-pi-mailbox.gob"
static char * 
mn_pi_mailbox_build_auth_id (MNPIMailbox * self, const char * username)
#line 775 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::build_auth_id"
#line 390 "mn-pi-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 390 "mn-pi-mailbox.gob"
	g_return_val_if_fail (MN_IS_PI_MAILBOX (self), (char * )0);
#line 782 "mn-pi-mailbox.c"
{
#line 392 "mn-pi-mailbox.gob"
	
    return g_strdup_printf("%s:%s:%i:%i:%s",
			   MN_MAILBOX_GET_CLASS(self)->type,
			   self->hostname,
			   self->runtime_port,
			   self->connection_type,
			   username);
  }}
#line 793 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 401 "mn-pi-mailbox.gob"
static char * 
mn_pi_mailbox_get_password (MNPIMailbox * self, const char * username)
#line 799 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::get_password"
#line 401 "mn-pi-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 401 "mn-pi-mailbox.gob"
	g_return_val_if_fail (MN_IS_PI_MAILBOX (self), (char * )0);
#line 401 "mn-pi-mailbox.gob"
	g_return_val_if_fail (username != NULL, (char * )0);
#line 808 "mn-pi-mailbox.c"
{
#line 403 "mn-pi-mailbox.gob"
	
    char *auth_id;
    char *password;

    auth_id = self_build_auth_id(self, username);

    G_LOCK(password_database);
    password = g_strdup(g_hash_table_lookup(password_database, auth_id));
    G_UNLOCK(password_database);

    g_free(auth_id);

    return password;
  }}
#line 825 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 418 "mn-pi-mailbox.gob"
static void 
mn_pi_mailbox_set_password (MNPIMailbox * self, const char * username, const char * password)
#line 831 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::set_password"
#line 418 "mn-pi-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 418 "mn-pi-mailbox.gob"
	g_return_if_fail (MN_IS_PI_MAILBOX (self));
#line 418 "mn-pi-mailbox.gob"
	g_return_if_fail (username != NULL);
#line 840 "mn-pi-mailbox.c"
{
#line 420 "mn-pi-mailbox.gob"
	
    char *auth_id;

    auth_id = self_build_auth_id(self, username);

    G_LOCK(password_database);
    if (password)
      g_hash_table_insert(password_database, g_strdup(auth_id), g_strdup(password));
    else
      g_hash_table_remove(password_database, auth_id);
    G_UNLOCK(password_database);

    g_free(auth_id);
  }}
#line 857 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 435 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_session_private_init (MNPIMailbox * self, MNClientSessionPrivate * priv)
#line 863 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::session_private_init"
#line 435 "mn-pi-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 435 "mn-pi-mailbox.gob"
	g_return_if_fail (MN_IS_PI_MAILBOX (self));
#line 435 "mn-pi-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 872 "mn-pi-mailbox.c"
{
#line 437 "mn-pi-mailbox.gob"
	
    priv->mailbox = MN_MAILBOX(self);
    priv->pi_mailbox = MN_PI_MAILBOX(self);
  }}
#line 879 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 442 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_sasl_get_credentials_cb (MNClientSession * session, MNClientSessionPrivate * priv, const char ** username, const char ** password)
#line 885 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::sasl_get_credentials_cb"
{
#line 447 "mn-pi-mailbox.gob"
	
#if WITH_SASL
    g_return_val_if_fail(username != NULL || password != NULL, FALSE);

    if (self_fill_credentials(priv->pi_mailbox, username != NULL, password != NULL))
      {
	if (username)
	  *username = priv->pi_mailbox->runtime_username;
	if (password)
	  *password = priv->pi_mailbox->runtime_password;

	return TRUE;
      }
    else
      return FALSE;
#else
    g_assert_not_reached();
    return FALSE;
#endif /* WITH_SASL */
  }}
#line 910 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 468 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_notice_cb (MNClientSession * session, const char * message, MNClientSessionPrivate * priv)
#line 916 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::notice_cb"
{
#line 472 "mn-pi-mailbox.gob"
	
    mn_mailbox_notice(priv->mailbox, "%s", message);
  }}
#line 924 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 476 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_warning_cb (MNClientSession * session, const char * message, MNClientSessionPrivate * priv)
#line 930 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::warning_cb"
{
#line 480 "mn-pi-mailbox.gob"
	
    mn_mailbox_warning(priv->mailbox, "%s", message);
  }}
#line 938 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
